/** 
* @file MSH2004DTTSymbols.h
*
* Declaration of class MSH2004DTTSymbols.
*
* @author Jochen Kerdels
*/

#ifndef __MSH2004DTTSymbols_h_
#define __MSH2004DTTSymbols_h_

#include "../../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"
#include "Tools/DynamicTeamTactic/TacticChooser.h"

/**
* The Xabsl2 symbols that are defined in "dtt-symbols.xml"
*
* @author Jochen Kerdels
*/ 
class MSH2004DTTSymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
private:
  
public:
  
/*
* Constructor.
* @param interfaces The paramters of the BehaviorControl module.
* @param kickInProgress  just a little hack for option rating
  */
  MSH2004DTTSymbols(const BehaviorControlInterfaces& interfaces, 
    TacticChooser** tacticChooser,    
    bool& kickInProgress
    );
  
  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);
  
  /** updates the symbols */
  void update();
  
  //!@name Input symbols
  //!@{
  
  // the choosen option
  RateableOptions::OptionID actualOption;
  
  // the type of the choosen option
  RateableOptions::OptionType actualOptionType;
  
  // intercept position 1
  Vector2<double> intercept1;
  // intercept position 2
  Vector2<double> intercept2;
  // intercept position 3
  Vector2<double> intercept3;
  // intercept position 4
  Vector2<double> intercept4;
  
  // goalie position 
  Vector2<double> goaliePos;
  
  // backUp position 
  Vector2<double> backUpPos;
  
  /** A function to report wether a kick is in progress or not */
  void setKickStatus(int number);
  
  //!@}
  
  TacticChooser** actualTacticChooser;
  
  /** hack for optionRating */
  bool& kickInProgress;
};


#endif // __MSH2004DTTSymbols_h_

/*
* Change Log
* 
* $Log: MSH2004DTTSymbols.h,v $
* Revision 1.12  2004/04/14 06:37:16  loetzsch
* removed the hack "kickInProgress" from the BehaviorControlInterfaces
*
* Revision 1.11  2004/04/08 15:33:04  wachter
* GT04 checkin of Microsoft-Hellounds
*
* Revision 1.11  2004/03/29 11:34:12  pg_joke
* added output symbols kick.status.started and kick.status.stopped
*
* Revision 1.10  2004/03/09 19:53:29  kerdels
* removed a myterious error ...
*
* Revision 1.9  2004/03/08 01:07:12  roefer
* Interfaces should be const
*
* Revision 1.8  2004/02/19 16:27:05  kerdels
* rated backUp option,
* made modifications discussed with michael,
* added backUp option to default.dtt
*
* Revision 1.7  2004/01/29 23:23:54  kerdels
* added symbol to dtt-symbols and put the radiobuttons in WLAN-Dialog to work... ok... with a hack
*
* Revision 1.6  2004/01/27 02:32:19  kerdels
* restructuring the restructuring of our xabsl-stuff... +
* found and removed a bad bug in collectedBeliefs.cpp
*
* Revision 1.5  2004/01/22 17:18:26  kerdels
* intercept-options hinzugefgt
*
* Revision 1.4  2003/12/17 20:51:29  kerdels
* Updated dtt-symbols
*
* Revision 1.3  2003/12/11 19:36:59  kerdels
* Debugged.
*
* Revision 1.2  2003/12/11 18:28:21  kerdels
* DTT Framework fertiggestellt.
*
* Revision 1.1  2003/12/11 17:07:25  kerdels
* Symbols fr DTT erstellt.
*
*
*/

