/**
* @file MSH2004KickEngineSearchResult.h
* 
* Implementation of class MSH2004KickEngineSearchResult.h
*
* @author Carsten Schumann (schumann@tempus-vivit.net)
*/

#ifndef __MSH2004KickEngineSearchResult_h_
#define __MSH2004KickEngineSearchResult_h_

#include "Representations/Motion/MotionRequest.h"
#include "Representations/Cognition/BallModel.h"

class MSH2004KickEngineSearchResult{
public:
  int foundBallX;
  int foundBallY;
  int foundKickSector;
  int foundKickDistance;
  int positiveClusterPoints;
  int negativeClusterPoints;
  double ballXwhenCreated;
  double ballYwhenCreated;

  Vector2<double> getNeededMovement(SeenBallPosition ballPosition, Pose2D robotPose);
  Vector2<double> getAbsolutePosition(SeenBallPosition ballPosition, Pose2D robotPose);
  Vector2<double> getAbsolutePositionForWalking(SeenBallPosition ballPosition, Pose2D robotPose);
  Vector2<double> getRelativeBall(SeenBallPosition ballPosition, Pose2D robotPose);


//  double movement_x; //relative to robot
//  double movement_y;

  double successRate;
  double foundSearchDistance;
  MotionRequest::SpecialActionID kick;
  int count;          //at search unknown number of remaining training points
};





#endif


/*
 * Change log :
 * 
 * $Log: MSH2004KickEngineSearchResult.h,v $
 * Revision 1.1  2004/04/08 16:04:05  wachter
 * GT04 checkin of Microsoft-Hellounds
 *
 * Revision 1.2  2004/03/30 14:12:30  pg_cars
 * Added improved ball grabbing
 *
 * Revision 1.1  2004/03/25 21:05:25  pg_cars
 * change of datafile, before backup
 *
*/
