/**
* @file MSH2004KickEngineKick.cpp
* 
* Implementation of class MSH2004KickEngineKick.
*
* @author Carsten Schumann (schumann@tempus-vivit.net)
*/
 
#include "MSH2004KickEngineSearchResult.h"

Vector2<double> MSH2004KickEngineSearchResult::getNeededMovement(SeenBallPosition ballPosition, Pose2D robotPose)
// relative to robot
{
  Vector2<double> destination;
  destination.x=this->foundBallX*20; 
  destination.y=this->foundBallY*20;
 
  Vector2<double> ballRelative=this->getRelativeBall(ballPosition,robotPose);
  Vector2<double> movement=ballRelative-destination;

  return movement;
}


Vector2<double> MSH2004KickEngineSearchResult::getAbsolutePosition(SeenBallPosition ballPosition, Pose2D robotPose)
{
  Vector2<double> target;
  Vector2<double> neededMovement=this->getNeededMovement(ballPosition,robotPose);

  target.x=robotPose.translation.x+cos(robotPose.rotation)*neededMovement.x+sin(robotPose.rotation)*neededMovement.y;
  target.y=robotPose.translation.y+sin(robotPose.rotation)*neededMovement.x+cos(robotPose.rotation)*neededMovement.y;

  return target;

}

Vector2<double> MSH2004KickEngineSearchResult::getAbsolutePositionForWalking(SeenBallPosition ballPosition, Pose2D robotPose)
{
  Vector2<double> target;
  Vector2<double> neededMovement=this->getNeededMovement(ballPosition,robotPose)*2;

  target.x=robotPose.translation.x+cos(robotPose.rotation)*neededMovement.x+sin(robotPose.rotation)*neededMovement.y;
  target.y=robotPose.translation.y+sin(robotPose.rotation)*neededMovement.x+cos(robotPose.rotation)*neededMovement.y;

  return target;

}

Vector2<double> MSH2004KickEngineSearchResult::getRelativeBall(SeenBallPosition ballPosition, Pose2D robotPose)
{
  double robotRelativeAngle=Geometry::angleTo(robotPose,ballPosition);
  double distance=sqrt(sqr(robotPose.translation.x-ballPosition.x)+sqr(robotPose.translation.y-ballPosition.y));

  Vector2<double> v;
  
  
  v.y=sin(robotRelativeAngle)*distance; 
  v.x=cos(robotRelativeAngle)*distance; 
  return v;
}
//----------------------------------------------------------------------------


/*
 * Change log :
 * 
 * $Log: MSH2004KickEngineSearchResult.cpp,v $
 * Revision 1.1  2004/04/08 16:04:05  wachter
 * GT04 checkin of Microsoft-Hellounds
 *
 * Revision 1.1  2004/03/25 21:05:24  pg_cars
 * change of datafile, before backup
 *
*/
