/**
* @file MSH2004KickEngineEntry.h
* 
* Implementation of class MSH2004KickEngineEntry.h
*
* @author Carsten Schumann (schumann@tempus-vivit.net)
*/
 
#ifndef __MSH2004KickEngineEntry_h_
#define __MSH2004KickEngineEntry_h_

#include "Representations/Motion/MotionRequest.h"
#include "Tools/List.h"
#include "Tools/Streams/InStreams.h"
#include "Tools/Streams/OutStreams.h"
#include "MSH2004KickEngineKick.h"
#include "MSH2004KickEngineSearchResult.h"

class MSH2004KickEngineEntry
{
public:
  MSH2004KickEngineEntry();
  ~MSH2004KickEngineEntry();
  void addKick(int kickSector, int kickDistance, MotionRequest::SpecialActionID kick);
  MSH2004KickEngineSearchResult getPreferredKick(unsigned short int kickSector, unsigned short int kickDistance);
  MSH2004KickEngineSearchResult getNeighbourhoodKick(unsigned short int kickSector, 
                                                     unsigned short int kickDistance,
                                                     double maxKickTolerance,
                                                     double distanceForKickSector,
                                                     double distanceForKickDistance);
  bool kickKnown(MotionRequest::SpecialActionID kick);
  bool kickDataKnown(MotionRequest::SpecialActionID kick);
  bool goodResultKnown(MotionRequest::SpecialActionID kick);
  void registerTry(MotionRequest::SpecialActionID kick);
  List<MSH2004KickEngineKick*>::Pos findEntry(MotionRequest::SpecialActionID kick);
  bool positiveClusterPoint(unsigned short int kickDistance,
                            unsigned short int kickSector,
                            MotionRequest::SpecialActionID kick);
  bool negativeClusterPoint(unsigned short int kickDistance,
                            unsigned short int kickSector,
                            MotionRequest::SpecialActionID kick);
  void loadKickTries(MotionRequest::SpecialActionID kick,In& stream,char* buffer);
  void loadKickResults(MotionRequest::SpecialActionID kick,In& stream,char* buffer);
  void saveKick(MotionRequest::SpecialActionID kick, Out& stream);
private:
  List<MSH2004KickEngineKick*>* kicks;

  void clear();

};



#endif

/*
 * Change log :
 * 
 * $Log: MSH2004KickEngineEntry.h,v $
 * Revision 1.6  2004/04/08 15:33:04  wachter
 * GT04 checkin of Microsoft-Hellounds
 *
 * Revision 1.7  2004/03/26 15:31:34  pg_cars
 * Improved data file format, improved debugging
 *
 * Revision 1.6  2004/03/25 21:05:24  pg_cars
 * change of datafile, before backup
 *
 * Revision 1.5  2004/03/15 15:59:46  schumann
 * splitted symbols for kick engine from other symbols
 *
 * Revision 1.4  2004/03/09 14:13:32  schumann
 * changed training for kickengine
 *
 * Revision 1.3  2004/03/04 08:37:41  schumann
 * added neighbourhood search
 *
 * Revision 1.2  2004/02/24 13:51:05  schumann
 * Changed structure of kick engine
 *
 * Revision 1.1  2004/02/23 12:51:37  schumann
 * Added MSH2004KickEngine
 *
*/

