/**
 * @file SpecialEventAnalyser.h
 * 
 * Implementation of class SpecialEventAnalyser.
 *
 * @author <A href=mailto:jochen@kerdels.de>Jochen Kerdels</A>
 */

#ifndef __SpecialEventAnalyser_h_
#define __SpecialEventAnalyser_h_

#include "Tools/DynamicTeamTactic/GlobalAnalyser.h"


/**
* @class SpecialEventAnalyser
*
* A simple implementation of the SpecialEventAnalyser class.
*
*/
class SpecialEventAnalyser : public GlobalAnalyser
{
private:
  
  double calcWeights[RateableOptions::spEv_Max - RateableOptions::spEv_Neutral];

  unsigned long ballOwnHalfEnteringTime;

  bool ballInOwnHalf;

public:

  /** 
   * Constructor.
   * @param interfaces The parameters of the SpecialEventAnalyser class.
   */
  SpecialEventAnalyser(const BehaviorControlInterfaces& interfaces);

	virtual void update();

	virtual double getWeight(RateableOptions::TacticEntryTypeID tacticEntryType);

};

#endif // __SpecialEventAnalyser_h_

/*
 * Change log :
 * $Log: SpecialEventAnalyser.h,v $
 * Revision 1.3  2004/04/08 15:33:04  wachter
 * GT04 checkin of Microsoft-Hellounds
 *
 * Revision 1.3  2004/04/04 01:27:52  kerdels
 * adjusted defence behavior
 *
 * Revision 1.2  2004/03/08 01:07:11  roefer
 * Interfaces should be const
 *
 * Revision 1.1  2004/02/19 23:34:59  kerdels
 * added SpecialEventAnalyser
 *
 *
 */
