/**
* @file SpecialEventAnalyser.cpp
* 
* Implementation of class SpecialEventAnalyser
*
*/

#include "SpecialEventAnalyser.h"
#include "Tools/DynamicTeamTactic/RateableOptions.h"

SpecialEventAnalyser::SpecialEventAnalyser(const BehaviorControlInterfaces& interfaces)
: GlobalAnalyser(interfaces)
{
  ballInOwnHalf = false;
}

void SpecialEventAnalyser::update()
{
  double fourPlayersLeft  = 0.0;
  double threePlayersLeft = 0.0;
  double twoPlayersLeft   = 0.0;
  double onePlayerLeft    = 0.0;

  int numOfOwn = playerPoseCollection.numberOfOwnPlayers;

  for (int i=0; i<3; ++i)
  {
    if (    (teamMessageCollection[i].isActual())
      && (teamMessageCollection[i].behaviorTeamMessage.gameState == BehaviorTeamMessage::penalized ) )
      numOfOwn--;
  }

//  INFO(sendOptionRatings, idText, text, "numOfOwn: " << numOfOwn);

  if (numOfOwn < 0)
    numOfOwn = 0;
  if (numOfOwn > 3)
    numOfOwn = 3;

  switch (numOfOwn)
  {
    case 0 : onePlayerLeft    = 1.0; break;
    case 1 : twoPlayersLeft   = 1.0; break;
    case 2 : threePlayersLeft = 1.0; break;
    case 3 : fourPlayersLeft  = 1.0; break;
  }

  if ((ballInOwnHalf == false) && (ballPosition.getKnownPosition(1500).x < 0))
  {
    ballInOwnHalf = true;
    ballOwnHalfEnteringTime = SystemCall::getCurrentSystemTime();
  }
  if (ballPosition.getKnownPosition(1500).x > 0)
    ballInOwnHalf = false;

  double konterWeight = 0.0;

  if (ballInOwnHalf)
  {
    unsigned long ballTimeInOwnHalf = SystemCall::getCurrentSystemTime() - ballOwnHalfEnteringTime;
    if (ballTimeInOwnHalf > 10000)
      ballTimeInOwnHalf = 10000;
    konterWeight = (1 - (ballTimeInOwnHalf / 10000)) * 4;
  }

	calcWeights[RateableOptions::spEv_Neutral - RateableOptions::spEv_Neutral] = 1.0;

	calcWeights[RateableOptions::spEv_NothingSpecial - RateableOptions::spEv_Neutral] = 1.0;

	calcWeights[RateableOptions::spEv_NoBall - RateableOptions::spEv_Neutral] = 0.0;

	calcWeights[RateableOptions::spEv_FourPlayersLeft - RateableOptions::spEv_Neutral] = fourPlayersLeft;

  calcWeights[RateableOptions::spEv_ThreePlayersLeft - RateableOptions::spEv_Neutral] = threePlayersLeft;

  calcWeights[RateableOptions::spEv_TwoPlayersLeft - RateableOptions::spEv_Neutral] = twoPlayersLeft;

  calcWeights[RateableOptions::spEv_OnePlayerLeft - RateableOptions::spEv_Neutral] = onePlayerLeft;

  calcWeights[RateableOptions::spEv_Konter - RateableOptions::spEv_Neutral] = konterWeight;

}

double SpecialEventAnalyser::getWeight(RateableOptions::TacticEntryTypeID tacticEntryType)
{
  return calcWeights[tacticEntryType - RateableOptions::spEv_Neutral];
}


/*
 * Change log :
 * $Log: SpecialEventAnalyser.cpp,v $
 * Revision 1.4  2004/05/12 19:33:13  kerdels
 * merged the behavior changes during australian, american and japan open
 *
 * Revision 1.3  2004/04/08 15:33:04  wachter
 * GT04 checkin of Microsoft-Hellounds
 *
 * Revision 1.5  2004/04/04 01:27:52  kerdels
 * adjusted defence behavior
 *
 * Revision 1.4  2004/03/31 08:19:38  pg_joke
 * when a robot is penalized, the robot-count in specialEventAnalyser is adjusted
 *
 * Revision 1.3  2004/03/30 01:32:22  pg_joke
 * added new states to the SpecialEventAnalyser to determine how many teammates are connected via wlan. Used this information in a new, slightly bigger default.dtt. The old default.dtt is saved to tbaseV5.dtt and a copy of the new default.dtt is tbaseV6.dtt. Changed some OptionRatings too. Hopefully this stuff will improve the behavior when the network is broken.
 *
 * Revision 1.2  2004/03/08 01:07:11  roefer
 * Interfaces should be const
 *
 * Revision 1.1  2004/02/19 23:34:59  kerdels
 * added SpecialEventAnalyser
 *
 *
 */
