/**
 * @file OffDefAnalyser.h
 * 
 * Implementation of class OffDefAnalyser.
 *
 * @author <A href=mailto:jochen@kerdels.de>Jochen Kerdels</A>
 */

#ifndef __OffDefAnalyser_h_
#define __OffDefAnalyser_h_

#include "Tools/DynamicTeamTactic/GlobalAnalyser.h"


/**
* @class OffDefAnalyser
*
* A simple implementation of the OffDefAnalyser class.
*
*/
class OffDefAnalyser : public GlobalAnalyser
{
private:
  
  double calcWeights[RateableOptions::offDef_Max - RateableOptions::offDef_Neutral];

public:

  /** 
   * Constructor.
   * @param interfaces The parameters of the OffDefAnalyser class.
   */
  OffDefAnalyser(const BehaviorControlInterfaces& interfaces);

	virtual void update();

	virtual double getWeight(RateableOptions::TacticEntryTypeID tacticEntryType);

};

#endif // __OffDefAnalyser_h_

/*
 * Change log :
 * $Log: OffDefAnalyser.h,v $
 * Revision 1.3  2004/03/08 01:07:11  roefer
 * Interfaces should be const
 *
 * Revision 1.2  2004/01/04 01:00:46  kerdels
 * TacticDesigner hinzugefgt
 *
 * Revision 1.1  2003/12/29 12:26:27  kerdels
 * global analysis hinzugefgt
 *
 *
 */
