/**
* @file DefaultOptionRating.h
* 
* Implementation of class DefaultOptionRating.
*
* @author <A href=mailto:jochen@kerdels.de>Jochen Kerdels</A>
*/

#ifndef __DefaultOptionRating_h_
#define __DefaultOptionRating_h_

#include "Tools/DynamicTeamTactic/OptionRating.h"
#include "Tools/DynamicTeamTactic/ChooserRaterInterfaces.h"


/**
* @class DefaultOptionRating
*
* A simple implementation of the DefaultOptionRating class.
*
*/
class DefaultOptionRating : public OptionRating
{
public:
  
  enum FieldPositions {
    Teammate1 = 0,
      Teammate2,
      Teammate3,
      Ball,
      NextBall,
      FrontLeft,
      FrontPenLeft,
      FrontMiddle,
      FrontPenRight,
      FrontRight,
      MiddleLeft,
      Middle,
      MiddleRight,
      BehindLeft,
      BehindMiddle,
      BehindRight,
      OwnGoal,
      OpponentGoal,
      Intercept1, // must be after OwnGoal in this enum
      Intercept2, // must be after OwnGoal in this enum
      Intercept3, // must be after OwnGoal in this enum
      Intercept4, // must be after OwnGoal in this enum
      InterceptBall,
      GoaliePos,
      CatenaccioLeft,
      CatenaccioMiddle,
      CatenaccioRight,
      PenaltyPoint,
      ToFront,
      MiddleAtBall,
    FrontAtBall,
    BehindAtBall,
    RightAtBall,
    LeftAtBall,
      numOfFieldPositions
  };
  
  enum KickTimes {
    instant = 0,
      fast,
      medium,
      slow,
      veryslow,
      numOfKickTimes
  };
  
  typedef struct {
    Vector2<double> absPos;     // absolute position
    Vector2<double> relPos;     // relative position to robot
    double          relDist;    // relative distance to robot
    double          maxDist;    // max. possible relative distance to robot in decimeters
    int             distRating; // rating for the distance between robot and pos.
    // 0 is far, 100 is near
    double          relOrient;  // relative orientation to pos as cos(angle) + 1, so
    // with relOrient == 2 the robot looks directly to the pos
    // and with relOrient == 0 the robot looks in the opposite
    // direction
    double          relAngle;   // relative angle to pos from -180 to 180 degrees , counterclockwise!
    // so negative angle is right-turn, and positive angle is left-turn
    double          enemyFact1; // value between 0 and 1 which describes how many enemys
    // are on the way (max.2m) to pos (in a range of 30cm). 
    // 0 means a lot of enemys, 1 is nice to go
    double          enemyFact2; // value like enemyFact1, but without 30cm range at pos.
    double          teamFact1;  // value between 0 and 1 which describes how many teammates
    // are on the way (max.2m) to pos (in a range of 30cm). 
    // 0 means a lot of enemys, 1 is nice to go
    double          teamFact2;  // value like teamFact1, but without 30cm range at pos.
  } prePosData ;
  
  /** 
  * Constructor.
  * @param interfaces The parameters of the OptionRating class.
  * @param collectedBeliefs The collected-Beliefs to work on.
  * @param chooserRaterInterfaces We want to talk to the tactic-Chooser.
  * @param kickInProgress  just a little hack for option rating
  */
  DefaultOptionRating(const BehaviorControlInterfaces& interfaces,
    CollectedBeliefs& collectedBeliefs,
    ChooserRaterInterfaces& chooserRaterInterfaces,
    bool& kickInProgress
    );
  
  /** rating the Options in here... */
  virtual void rateOptions();
  
  // "Richtungsvektor" of the robot
  Vector2<double> robotOrient;
  // length of the "Richtungsvektor"
  double robotODist; 
  
  // array to store preCalc-Data
  prePosData fieldPosData[numOfFieldPositions];
  
  // relative directions to EnemyPositions and length of those vectors
  Vector2<double> enemyRelPos[4];
  double enemyRelDist[4];
  double enemyValidity[4];
  
  // relative directions to teammatesPositions and length of those vectors
  Vector2<double> teamRelPos[3];
  double teamRelDist[3];
  double teamValidity[3];
  
  double ballValidity;
  double ballMotionValidity;
  double ballSpeed;
  double OrientDiff;
  Vector2<double> prevPos;
  unsigned long lastDoJumpDefend;
  
  // relative direction of all robots to interceptBall Position, length of this vector
  Vector2<double> interceptRelPos[4];
  double interceptRelDist[4];
  
  // some precalculations for kick-rating
  double kickTimeFact[numOfKickTimes];
  
private:

  int ocrating[5];
  
  bool freshDefend;
  Vector2<double> ballSensedPos;
  
  unsigned long   ballSensedTime;
  Vector2<double> ballSensedRelPos;
  
  int jumpDefendRating;
  int jumpLeftRating;
  int jumpRightRating;
  
  SlidingAverageValue ballBase;
  SlidingAverageValue ballAct;

  void doPreCals();
  
  // OptionRating for FieldPositions
  int getGoToFieldPosRating(FieldPositions fpos);
  
  // OptionRating for KickToTeammates (mate ranges from 1 to 3)
  int getKickToTeammateRating(int mate);
  
  // OptionRating for specialKicksToPos
  int getSpecialKickToPosRating(int kickangle, int kickrange, KickTimes kicktime, FieldPositions fpos);
  
  // OptionRating for KicksToPos
  int getKickToPosRating(FieldPositions fpos);
  
  // OptionRating for rolling
  int getRollRating(int bdist, int bangle);
  
  // OptionRating for position-depended goToBall
  int getGoToBallRating(FieldPositions fpos, int goToBallRating);
  
  // OptionRating for position-depended kickToX
  int getKickFromRating(FieldPositions fpos, int kickRating);
};

#endif // __DefaultOptionRating_h_

/*
* Change log :
* $Log: DefaultOptionRating.h,v $
* Revision 1.39  2004/06/17 09:47:48  hamerla
* OC rollenzuteilung
*
* Revision 1.38  2004/05/12 19:33:12  kerdels
* merged the behavior changes during australian, american and japan open
*
* Revision 1.37  2004/04/14 06:37:16  loetzsch
* removed the hack "kickInProgress" from the BehaviorControlInterfaces
*
* Revision 1.36  2004/04/08 15:33:03  wachter
* GT04 checkin of Microsoft-Hellounds
*
* Revision 1.41  2004/04/01 03:34:47  pg_joke
* retuning of jump-ratings
*
* Revision 1.40  2004/04/01 02:46:29  pg_joke
* some further finetuning of jump-ratings
*
* Revision 1.39  2004/04/01 02:06:45  pg_joke
* upon a suggestion by walter the goalie now estimates where the ball will pass him. So he can decide to JumpDefend, JumpLeft or JumpRight.
*
* Revision 1.38  2004/03/31 18:46:45  pg_joke
* fine tuned jump defend rating and integrated it into default-dtt. But both - tacticEntrys in default.dtt and the ratings - are disabled (commented out) yet. A first, short test in the Arena looked quite good.
*
* Revision 1.37  2004/03/31 16:43:24  pg_joke
* created a new doJumpDefend, doJumpLeft, doJumpRight rating. not tested yet, so commented out.
*
* Revision 1.36  2004/03/24 15:11:35  pg_joke
* added location dependend kickratings to improve team-behavior
*
* Revision 1.35  2004/03/10 21:44:30  kerdels
* added goToMiddleAtBall Option
*
* Revision 1.34  2004/03/08 01:07:08  roefer
* Interfaces should be const
*
* Revision 1.33  2004/03/02 22:28:06  huelsbusch
* Added missing doxygen comments
*
* Revision 1.32  2004/03/01 17:14:04  kerdels
* added robot-pose.distance-to-opponent-goal,
* moved robot-pose.angle-to-teammate1-3 to MSH2004StrategySymbols as fieldpos.angle-to-teammate1-3,
* added fieldpos.distance-to-teammate1-3,
* added DTT-Options newKickToGoal, newKickToClear, newKickToTeammate1-3,
* added DTT-OptionClass newKickToTeammate,
* added kickToPosRating function in DefaultOptionRating
*
* Revision 1.31  2004/02/18 23:32:58  kerdels
* added goToFrontPenLeft, goToFrontPenRight
* added backUp, not rated yet
* splittet goto-switch.xml in goto-switch.xml and gotoBall-switch.xml
*
* Revision 1.30  2004/02/04 23:26:41  kerdels
* added kicksToClear, clearkick-switch and option-type, specialKickToClear optionClass and apropriate ratings,
* modified GoToBallPos ratings
*
* Revision 1.29  2004/02/03 23:47:33  kerdels
* added GoalieCoach and adjusted tactics.dat.
*
* Revision 1.28  2004/02/03 12:51:53  lohmann
* BananaCross splitted into Left and Right.
*
* Revision 1.27  2004/02/02 19:10:30  kerdels
* adjusted some options for the use with reflexes, created a simple version of turn-for-ball and modified some option ratings...
*
* Revision 1.26  2004/02/02 16:33:58  kerdels
* added DTT-options goToCatenaccioLeft, goToCatenaccioMiddle and goToCatenaccioRight.
* Also added catfun.dat to test this new options
*
* Revision 1.25  2004/01/30 17:47:37  rossbacher
* Added new doJumpDefend rating
*
* Revision 1.24  2004/01/29 23:56:35  kerdels
* added special goalie position to DTT
*
* Revision 1.23  2004/01/29 21:33:28  kerdels
* added turn-for-ball Option to DTT,
* added link between TacticChooser and OptionRating
*
* Revision 1.22  2004/01/28 23:27:32  kerdels
* added rollLeft and rollRight Option to DTT,
* rating has to be adjusted
*
* Revision 1.21  2004/01/28 18:28:58  kerdels
* aenderungen arena,
* mathias, frank, jochen
*
* Revision 1.20  2004/01/26 18:02:17  kerdels
* added heel-kicks to dtt
*
* Revision 1.19  2004/01/25 18:31:19  kerdels
* added specialKickToPosRating to DefaultOptionRating
*
* Revision 1.18  2004/01/25 16:57:32  kerdels
* added absPos and relAngle to preCalcArray
*
* Revision 1.17  2004/01/25 15:21:59  kerdels
* cleaned up a little bit
*
* Revision 1.16  2004/01/23 12:53:38  udo
* InterceptBall Position and Rating included
*
* Revision 1.15  2004/01/22 22:28:46  kerdels
* Optionen fr Bandenverhalten hinzugefuegt
*
* Revision 1.14  2004/01/22 17:18:26  kerdels
* intercept-options hinzugefgt
*
* Revision 1.13  2004/01/15 15:32:01  kerdels
* state penalized im option-rating beruecksichtigt
*
* Revision 1.12  2004/01/12 22:16:20  kerdels
* added rating of doJumpDefend, doJumpLeft and doJumpRight
*
* Revision 1.11  2004/01/08 20:18:18  kerdels
* kickToTeammate Rating verbessert
*
* Revision 1.10  2004/01/07 23:17:01  kerdels
* added symbols:
* robot-pose.angle-to-teammate1
* robot-pose.angle-to-teammate2
* robot-pose.angle-to-teammate3
*
* Revision 1.9  2004/01/07 17:15:07  kerdels
* added DTT-Option kickToGoal
*
* Revision 1.8  2004/01/07 14:56:08  kerdels
* added send functionality to TacticDesigner
*
* Revision 1.7  2004/01/06 18:43:25  kerdels
* added some DTT-Options,
* modified tactics.dat
*
* Revision 1.6  2004/01/05 20:44:20  kerdels
* div zero bug behoben
*
* Revision 1.5  2003/12/29 12:26:27  kerdels
* global analysis hinzugefgt
*
* Revision 1.4  2003/12/25 19:13:00  kerdels
* added approachCloseBall to DTT
*
* Revision 1.3  2003/12/23 17:39:09  kerdels
* DefaultOptionRating restrukturiert
*
* Revision 1.2  2003/12/23 16:20:37  kerdels
* DefaultOptionRating restrukturiert
*
* Revision 1.1  2003/12/11 18:28:22  kerdels
* DTT Framework fertiggestellt.
*
* Revision 1.1  2003/12/11 16:22:20  kerdels
* Die DynamicTeamTactic neu strukturiert und ins MSH2004 Behavior integriert..
*
* Revision 1.1  2003/12/10 20:46:11  kerdels
* CollectedBeliefs entfernt
*
* Revision 1.4  2003/12/10 09:55:38  dueffert
* doxygen bugs fixed
*
* Revision 1.3  2003/12/07 15:21:11  kindler
* spelling fixed.
*
* Revision 1.2  2003/12/07 15:03:43  kindler
* Changelog keyword added.
*
*/
