/**
* @file GT2003BehaviorControl.h
* 
* Implementation of class GT2003BehaviorControl.
*
* @author Martin Ltzsch
* @author Matthias Jngel
* @author Max Risler
*/

#ifndef __GT2003BehaviorControl_h_
#define __GT2003BehaviorControl_h_

#include "GT2003BasicBehaviors/GT2003SimpleBasicBehaviors.h"
#include "GT2003BasicBehaviors/GT2004EvolutionBasicBehaviors.h"
#include "GT2003BasicBehaviors/GT2003ContinuousBasicBehaviors.h"
#include "../CommonXabsl2BasicBehaviors/CommonBasicBehaviors.h"

#include "../CommonXabsl2Symbols/BallSymbols.h"
#include "../CommonXabsl2Symbols/HeadAndTailSymbols.h"
#include "../CommonXabsl2Symbols/JoystickSymbols.h"
#include "../CommonXabsl2Symbols/LEDAndSoundSymbols.h"
#include "../CommonXabsl2Symbols/MathFunctions.h"
#include "../CommonXabsl2Symbols/MotionRequestSymbols.h"
#include "../CommonXabsl2Symbols/RoboCupGameManagerSymbols.h"
#include "../CommonXabsl2Symbols/RobotPoseSymbols.h"
#include "../CommonXabsl2Symbols/RobotStateSymbols.h"
#include "../CommonXabsl2Symbols/SpecialVisionSymbols.h"
#include "../CommonXabsl2Symbols/ChallengeSymbols.h"
#include "../CommonXabsl2Symbols/CalibrationSymbols.h"
#include "Symbols/StrategySymbols.h"
#include "Symbols/EvolutionSymbols.h"
#include "Symbols/ConfigurationSymbols.h"

#include "../Xabsl2BehaviorControl.h"

#include "GT2003BehaviorConfiguration.h"

/**
* @class GT2003BehaviorControl
*
* A Behavior based on the Xabsl2Engine that is used by the GermanTeam for the 
* RoboCup Championships 2003 in Padova.
*
* @author Martin Ltzsch
* @author Matthias Jngel
* @author Max Risler
*/ 
class GT2003BehaviorControl : public Xabsl2BehaviorControl
{
public:
  /** 
  * Constructor.
  * @param interfaces The paramters of the BehaviorControl module.
  */
  GT2003BehaviorControl(const BehaviorControlInterfaces& interfaces);

  /** destructor */
  ~GT2003BehaviorControl();

  /** Registers symbols and basic behaviors at the engine */
  virtual void registerSymbolsAndBasicBehaviors();
  
  /** Executes the module */
  virtual void execute();

  /** 
  * Is called for every incoming debug message.
  * @param message An interface to read the message from the queue
  * @return if the messag was read
  */
  virtual bool handleMessage(InMessage& message);

  /**
  * contains the current configuration parameters 
  */
  GT2003BehaviorConfiguration configuration;

private:
  //!@name Symbols
  //!@{
  BallSymbols ballSymbols;
  ConfigurationSymbols configurationSymbols;
  HeadAndTailSymbols headAndTailSymbols;
  JoystickSymbols joystickSymbols;
  LEDAndSoundSymbols ledAndSoundSymbols;
  MathFunctions mathFunctions;
  MotionRequestSymbols motionRequestSymbols;
  RoboCupGameManagerSymbols roboCupGameManagerSymbols;
  RobotPoseSymbols robotPoseSymbols;
  RobotStateSymbols robotStateSymbols;
  SpecialVisionSymbols specialVisionSymbols;
  StrategySymbols strategySymbols;
  EvolutionSymbols evolutionSymbols;
  ChallengeSymbols challengeSymbols;
  CalibrationSymbols calibrationSymbols;
  //!@}

  //!@name Basic Behaviors
  //!@{
  GT2003SimpleBasicBehaviors simpleBasicBehaviors;
  GT2004EvolutionBasicBehaviors evolutionBasicBehaviors;
  GT2003ContinuousBasicBehaviors continuousBasicBehaviors;
  CommonBasicBehaviors commonBasicBehaviors;
  //!@}

  //!@name UD Evolution stuff
  //!@{
  UDParametersSet udParametersSet;
  UDParameters udExtraParameters;
  Pose2D udParametersCalibration[128];
  Pose2D measurementRequest;
  int evolutionMode;
  int udCurrentIndex;
  //!@}

  SoundRequest::SoundID lastSound;
};

#endif// __GT2003BehaviorControl_h_

/*
 * Change log :
 * 
 * $Log: GT2003BehaviorControl.h,v $
 * Revision 1.8  2004/05/27 13:31:26  dueffert
 * walking evolution stuff separated
 *
 * Revision 1.7  2004/05/14 10:16:06  dueffert
 * exact measurement behavior with logging implemented
 *
 * Revision 1.6  2004/04/16 14:56:36  dueffert
 * cleanup for Martins data flow graphics
 *
 * Revision 1.5  2004/03/21 12:47:33  juengel
 * Moved calibration symbols to common symbols.
 *
 * Revision 1.4  2004/03/08 01:06:57  roefer
 * Interfaces should be const
 *
 * Revision 1.3  2003/10/22 22:18:45  loetzsch
 * prepared the cloning of the GT2003BehaviorControl
 *
 * Revision 1.2  2003/10/12 11:53:22  juengel
 * Added calibration-symbols.
 *
 * Revision 1.1  2003/10/06 13:39:29  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.3  2003/07/21 19:18:05  loetzsch
 * - Xabsl2 AND and OR operators now can contain more than 2 operands
 * - speed improvements and cleanup
 *
 * Revision 1.2  2003/07/03 14:43:17  risler
 * new sounds
 *
 * Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.10  2003/06/22 14:25:01  roefer
 * Challenge 2 symbols added
 *
 * Revision 1.9  2003/05/25 14:41:40  risler
 * added GT2003BehaviorConfiguration
 *
 * Revision 1.8  2003/05/07 18:19:00  juengel
 * Added missing symbols to GT2003BehaviorControl.
 *
 * Revision 1.7  2003/05/07 17:27:59  risler
 * added MotionRequestSymbols
 *
 * Revision 1.6  2003/05/06 16:28:19  loetzsch
 * added class StrategySymbols
 *
 * Revision 1.5  2003/05/06 16:03:05  loetzsch
 * added class RobotPoseSymbols
 *
 * Revision 1.4  2003/05/06 14:46:12  loetzsch
 * added registration of generated GT2003BehaviorControl symbols
 *
 * Revision 1.3  2003/05/05 19:22:03  risler
 * added classes Simple/ContinuousBasicBehaviors for registering basic behaviors
 *
 * Revision 1.2  2003/05/04 11:41:40  loetzsch
 * added class BallSymbols
 *
 * Revision 1.1  2003/05/03 15:14:02  loetzsch
 * GT2003BehaviorControl first draft
 *
 */
