/**
* @file GT2003ContinuousRules/WalkY.h
*
* @author Max Risler
*/

#ifndef __GT2003Rules_WalkY_h_
#define __GT2003Rules_WalkY_h_

#include "Tools/ContinuousBasicBehaviors/ContinuousRule.h"

namespace GT2003ContinuousRules
{

/**@class WalkX
 */
class WalkY: public ContinuousRule{
private:
  /** reference to the requested speed */
  const double &speedY;

public:
  /** constructor
   */
  WalkY(
    const BehaviorControlInterfaces& interfaces,
    const double &speedY)
    :
    ContinuousRule(interfaces,"WalkY"),
    speedY(speedY)
  {};

  /**
   * Returns whether this rule generates absolute or robot relative coordinates.
   * This rule is robot relative.
   */
  virtual bool isRelative() {return true;}

 	/** executes the basic behavior rule
   * @param robotPose the current robots pose at which the rule is to be evaluated
   * @param walk the direction and speed of the suggested motion coded as an vector (output)
	 * @param ra the rotation angle, the direction the robot should be directed (output)
	 * @param rweight the rotation weight the weight of the suggested rotation (output)
   */
  virtual void execute(const RobotPose& robotPose,
                       Vector2<double>& walk,
                       double& ra, double& rweight)
  {
    walk.x = 0;
    walk.y = speedY / walkMaxForwardSpeed;
    rweight=0;
  }
};

}

#endif //__GT2003Rules_WalkY_h_


/*
* Change log:
*
* $Log: WalkY.h,v $
* Revision 1.3  2004/03/08 01:06:56  roefer
* Interfaces should be const
*
* Revision 1.2  2003/10/31 08:32:48  dueffert
* doxygen bugs fixed
*
* Revision 1.1  2003/10/22 22:18:46  loetzsch
* prepared the cloning of the GT2003BehaviorControl
*
* Revision 1.1  2003/10/06 13:39:31  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.1  2003/06/18 15:37:25  risler
* added rules walkX, walkY
*
*/
