/** 
* @file DDD2004ConfigurationSymbols.h
*
* Declaration of class DDD2004ConfigurationSymbols.
*
* @author Max Risler
*/

#ifndef __DDD2004ConfigurationSymbols_h_
#define __DDD2004ConfigurationSymbols_h_

#include "../../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"
#include "../DDD2004BehaviorConfiguration.h"

/**
* The Xabsl2 symbols that are defined in "configuration-symbols.xml"
*
* @author Max Risler
*/ 
class DDD2004ConfigurationSymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
public:
/*
* Constructor.
* @param interfaces The parameters of the BehaviorControl module.
  */
  DDD2004ConfigurationSymbols(const BehaviorControlInterfaces& interfaces, DDD2004BehaviorConfiguration& configuration);
  
  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);

  /** updates the symbols */
  void update();

  //!@name Input symbols
  //!@{
  double getCurrentKickoff(); /*!< A function for the symbol "current-kickoff-variant" */
  double getOwnKickoffX(); /*!< A function for the symbol "own-kickoff.x" */
  double getOwnKickoffY(); /*!< A function for the symbol "own-kickoff.y" */
  double getOwnKickoffAngle(); /*!< A function for the symbol "own-kickoff.angle" */
  double getOpponentKickoffX(); /*!< A function for the symbol "opponent-kickoff.x" */
  double getOpponentKickoffY(); /*!< A function for the symbol "opponent-kickoff.y" */
  double getOpponentKickoffAngle(); /*!< A function for the symbol "opponent-kickoff.angle" */
  double getDribbleSpeedY(); /*!< A function for the symbol "dribble.speed-y" */
  //!@}
private:
  /**
  * contains the current configuration parameters 
  */
  DDD2004BehaviorConfiguration& configuration;

  /**
  * current own kickoff variant 
  */
  int currentKickoff;
};


#endif // __DDD2004ConfigurationSymbols_h_

/*
* Change Log
* 
* $Log: DDD2004ConfigurationSymbols.h,v $
* Revision 1.3  2004/03/08 01:06:48  roefer
* Interfaces should be const
*
* Revision 1.2  2003/10/31 08:32:48  dueffert
* doxygen bugs fixed
*
* Revision 1.1  2003/10/26 22:49:38  loetzsch
* created ATH2004BehaviorControl from GT2003BehaviorControl
*  - strongly simplified option graph
*  - moved some symbols from GT2003 to CommonXabsl2Symbols
*  - moved some basic behaviors from GT2003 to CommonXabsl2BasicBehaviors
*
* cloned ATH2004 three times (BB2004, DDD2004, MSH2004)
*
*/

