/** 
* @file DDD2004ConfigurationSymbols.cpp
*
* Implementation of class DDD2004ConfigurationSymbols.
*
* @author Max Risler
*/

#include "DDD2004ConfigurationSymbols.h"

DDD2004ConfigurationSymbols::DDD2004ConfigurationSymbols(
                           const BehaviorControlInterfaces& interfaces,
                           DDD2004BehaviorConfiguration& configuration)
: BehaviorControlInterfaces(interfaces),
  configuration(configuration)
{
  currentKickoff = 0;
}

void DDD2004ConfigurationSymbols::registerSymbols(Xabsl2Engine& engine)
{
  engine.registerDecimalInputSymbol("current-kickoff-variant",this,
    (double (Xabsl2FunctionProvider::*)())&DDD2004ConfigurationSymbols::getCurrentKickoff);

  engine.registerDecimalInputSymbol("go-to-kickoff-position.max-speed",&(configuration.goToKickoffMaxSpeed));

  engine.registerDecimalInputSymbol("own-kickoff.angle",this,
    (double (Xabsl2FunctionProvider::*)())&DDD2004ConfigurationSymbols::getOwnKickoffAngle);
  engine.registerDecimalInputSymbol("own-kickoff.x",this,
    (double (Xabsl2FunctionProvider::*)())&DDD2004ConfigurationSymbols::getOwnKickoffX);
  engine.registerDecimalInputSymbol("own-kickoff.y",this,
    (double (Xabsl2FunctionProvider::*)())&DDD2004ConfigurationSymbols::getOwnKickoffY);

  engine.registerDecimalInputSymbol("opponent-kickoff.angle",this,
    (double (Xabsl2FunctionProvider::*)())&DDD2004ConfigurationSymbols::getOpponentKickoffAngle);
  engine.registerDecimalInputSymbol("opponent-kickoff.x",this,
    (double (Xabsl2FunctionProvider::*)())&DDD2004ConfigurationSymbols::getOpponentKickoffX);
  engine.registerDecimalInputSymbol("opponent-kickoff.y",this,
    (double (Xabsl2FunctionProvider::*)())&DDD2004ConfigurationSymbols::getOpponentKickoffY);

  engine.registerDecimalInputSymbol("ball-near-distance",&(configuration.ballNearDistance));
  engine.registerDecimalInputSymbol("ball-not-near-distance",&(configuration.ballNotNearDistance));
  engine.registerDecimalInputSymbol("at-ball-distance",&(configuration.atBallDistance));
  engine.registerDecimalInputSymbol("not-at-ball-distance",&(configuration.notAtBallDistance));

  // "dribble.speed-y"
  engine.registerDecimalInputSymbol("dribble.speed-y",this,
    (double (Xabsl2FunctionProvider::*)())&DDD2004ConfigurationSymbols::getDribbleSpeedY);
}

void DDD2004ConfigurationSymbols::update()
{
  currentKickoff = gameControlData.data.opponentScore % DDD2004BehaviorConfiguration::numOfKickoff;
}

double DDD2004ConfigurationSymbols::getCurrentKickoff()
{
  return currentKickoff;
}

double DDD2004ConfigurationSymbols::getOwnKickoffAngle()
{
  switch (getPlayer().getPlayerNumber())
  {
    case Player::one: // robot number 1
    default:
      return 0;
    case Player::two: // robot number 2
      return configuration.strikerOwnKickoffAngle[currentKickoff];
    case Player::three: // robot number 3
      return configuration.offensiveSupporterOwnKickoffAngle[currentKickoff];
    case Player::four: // robot number 4
      return 0;
  }
}

double DDD2004ConfigurationSymbols::getOwnKickoffX()
{
  switch (getPlayer().getPlayerNumber())
  {
    case Player::one: // robot number 1
    default:
      return configuration.goalie.x;
    case Player::two: // robot number 2
      return configuration.strikerOwnKickoff[currentKickoff].x;
    case Player::three: // robot number 3
      return configuration.offensiveSupporterOwnKickoff[currentKickoff].x;
    case Player::four: // robot number 4
      return configuration.defensiveSupporter.x;
  }
}

double DDD2004ConfigurationSymbols::getOwnKickoffY()
{
  switch (getPlayer().getPlayerNumber())
  {
    case Player::one: // robot number 1
    default:
      return configuration.goalie.y;
    case Player::two: // robot number 2
      return configuration.strikerOwnKickoff[currentKickoff].y;
    case Player::three: // robot number 3
      return configuration.offensiveSupporterOwnKickoff[currentKickoff].y;
    case Player::four: // robot number 4
      return configuration.defensiveSupporter.y;
  }
}

double DDD2004ConfigurationSymbols::getOpponentKickoffAngle()
{
  switch (getPlayer().getPlayerNumber())
  {
    case Player::one: // robot number 1
    case Player::two: // robot number 2
    case Player::three: // robot number 3
    case Player::four: // robot number 4
    default:
      return 0;
  }
}

double DDD2004ConfigurationSymbols::getOpponentKickoffX()
{
  switch (getPlayer().getPlayerNumber())
  {
    case Player::one: // robot number 1
    default:
      return configuration.goalie.x;
    case Player::two: // robot number 2
      return configuration.strikerOpponentKickoff.x;
    case Player::three: // robot number 3
      return configuration.offensiveSupporterOpponentKickoff.x;
    case Player::four: // robot number 4
      return configuration.defensiveSupporter.x;
  }
}

double DDD2004ConfigurationSymbols::getOpponentKickoffY()
{
  switch (getPlayer().getPlayerNumber())
  {
    case Player::one: // robot number 1
    default:
      return configuration.goalie.y;
    case Player::two: // robot number 2
      return configuration.strikerOpponentKickoff.y;
    case Player::three: // robot number 3
      return configuration.offensiveSupporterOpponentKickoff.y;
    case Player::four: // robot number 4
      return configuration.defensiveSupporter.y;
  }
}

double DDD2004ConfigurationSymbols::getDribbleSpeedY()
{
  double distanceY = Geometry::distanceTo(robotPose.getPose(),ballPosition.seen) * 
    sin(Geometry::angleTo(robotPose.getPose(),ballPosition.seen));

  if (distanceY < -175)
    return -200;
  else if (distanceY < 0)
    return (150 + 2 * distanceY); 
  else if (distanceY < 175)
    return (-150 + 2 * distanceY);
  else return 200;
}


/*
* Change Log
* 
* $Log: DDD2004ConfigurationSymbols.cpp,v $
* Revision 1.4  2004/04/07 12:28:57  risler
* ddd checkin after go04 - first part
*
* Revision 1.2  2004/04/02 02:22:22  risler
* players 2 and 4 exchanged
*
* Revision 1.1.1.1  2004/03/29 08:28:49  Administrator
* initial transfer from tamara
*
* Revision 1.3  2004/03/08 01:06:48  roefer
* Interfaces should be const
*
* Revision 1.2  2003/12/06 17:45:33  loetzsch
* replaced Player::playerRole (goalie, defender, striker1, striker2)
* by Player::playerNumber (one, two, three, four)
*
* Revision 1.1  2003/10/26 22:49:38  loetzsch
* created ATH2004BehaviorControl from GT2003BehaviorControl
*  - strongly simplified option graph
*  - moved some symbols from GT2003 to CommonXabsl2Symbols
*  - moved some basic behaviors from GT2003 to CommonXabsl2BasicBehaviors
*
* cloned ATH2004 three times (BB2004, DDD2004, MSH2004)
*
*/

