/**
* @file DDD2004BehaviorControl.h
* 
* Implementation of class DDD2004BehaviorControl.
*
* @author Martin Ltzsch
*/

#ifndef __DDD2004BehaviorControl_h_
#define __DDD2004BehaviorControl_h_

#include "DDD2004BasicBehaviors/DDD2004SimpleBasicBehaviors.h"
#include "DDD2004BasicBehaviors/DDD2004ContinuousBasicBehaviors.h"
#include "../CommonXabsl2BasicBehaviors/CommonBasicBehaviors.h"

#include "../CommonXabsl2Symbols/BallSymbols.h"
#include "../CommonXabsl2Symbols/HeadAndTailSymbols.h"
#include "../CommonXabsl2Symbols/JoystickSymbols.h"
#include "../CommonXabsl2Symbols/LEDAndSoundSymbols.h"
#include "../CommonXabsl2Symbols/MathFunctions.h"
#include "../CommonXabsl2Symbols/MotionRequestSymbols.h"
#include "../CommonXabsl2Symbols/RoboCupGameManagerSymbols.h"
#include "../CommonXabsl2Symbols/RobotPoseSymbols.h"
#include "../CommonXabsl2Symbols/RobotStateSymbols.h"
#include "../CommonXabsl2Symbols/SpecialVisionSymbols.h"
#include "../CommonXabsl2Symbols/ChallengeSymbols.h"
#include "DDD2004Symbols/DDD2004StrategySymbols.h"
#include "DDD2004Symbols/DDD2004ConfigurationSymbols.h"

#include "../Xabsl2BehaviorControl.h"

#include "DDD2004BehaviorConfiguration.h"

/**
* @class DDD2004BehaviorControl
*
* A Behavior based on the Xabsl2Engine that is used by the Darmstadt Dribbling Dackels
* for the RoboCup German Open 2004.
*
* @author Martin Ltzsch
*/ 
class DDD2004BehaviorControl : public Xabsl2BehaviorControl
{
public:
  /** 
  * Constructor.
  * @param interfaces The paramters of the BehaviorControl module.
  */
  DDD2004BehaviorControl(const BehaviorControlInterfaces& interfaces);

  /** destructor */
  ~DDD2004BehaviorControl();

  /** Registers symbols and basic behaviors at the engine */
  virtual void registerSymbolsAndBasicBehaviors();
  
  /** Executes the module */
  virtual void execute();

  /** 
  * Is called for every incoming debug message.
  * @param message An interface to read the message from the queue
  * @return if the messag was read
  */
  virtual bool handleMessage(InMessage& message);

  /**
  * contains the current configuration parameters 
  */
  DDD2004BehaviorConfiguration configuration;

private:
  //!@name Symbols
  //!@{
  BallSymbols ballSymbols;
  DDD2004ConfigurationSymbols configurationSymbols;
  HeadAndTailSymbols headAndTailSymbols;
  JoystickSymbols joystickSymbols;
  LEDAndSoundSymbols ledAndSoundSymbols;
  MathFunctions mathFunctions;
  MotionRequestSymbols motionRequestSymbols;
  RoboCupGameManagerSymbols roboCupGameManagerSymbols;
  RobotPoseSymbols robotPoseSymbols;
  RobotStateSymbols robotStateSymbols;
  SpecialVisionSymbols specialVisionSymbols;
  DDD2004StrategySymbols strategySymbols;
  ChallengeSymbols challengeSymbols;
  //!@}

  //!@name Basic Behaviors
  //!@{
  DDD2004SimpleBasicBehaviors simpleBasicBehaviors;
  DDD2004ContinuousBasicBehaviors continuousBasicBehaviors;
  CommonBasicBehaviors commonBasicBehaviors;
  //!@}

  SoundRequest::SoundID lastSound;
};

#endif// __DDD2004BehaviorControl_h_

/*
 * Change log :
 * 
 * $Log: DDD2004BehaviorControl.h,v $
 * Revision 1.2  2004/03/08 01:06:48  roefer
 * Interfaces should be const
 *
 * Revision 1.1  2003/10/26 22:49:37  loetzsch
 * created ATH2004BehaviorControl from GT2003BehaviorControl
 *  - strongly simplified option graph
 *  - moved some symbols from GT2003 to CommonXabsl2Symbols
 *  - moved some basic behaviors from GT2003 to CommonXabsl2BasicBehaviors
 *
 * cloned ATH2004 three times (BB2004, DDD2004, MSH2004)
 *
 */
