/**
* @file DDD2004ContinuousRules/WalkY.h
*
* @author Max Risler
*/

#ifndef __DDD2004Rules_WalkY_h_
#define __DDD2004Rules_WalkY_h_

#include "Tools/ContinuousBasicBehaviors/ContinuousRule.h"

namespace DDD2004ContinuousRules
{

/**@class WalkX
 */
class WalkY: public ContinuousRule{
private:
  /** reference to the requested speed */
  const double &speedY;

public:
  /** constructor
   */
  WalkY(
    const BehaviorControlInterfaces& interfaces,
    const double &speedY)
    :
    ContinuousRule(interfaces,"WalkY"),
    speedY(speedY)
  {};

  /**
   * Returns whether this rule generates absolute or robot relative coordinates.
   * This rule is robot relative.
   */
  virtual bool isRelative() {return true;}

 	/** executes the basic behavior rule
   * @param robotPose the current robots pose at which the rule is to be evaluated
   * @param walk the direction and speed of the suggested motion coded as an vector (output)
	 * @param ra the rotation angle, the direction the robot should be directed (output)
	 * @param rweight the rotation weight the weight of the suggested rotation (output)
   */
  virtual void execute(const RobotPose& robotPose,
                       Vector2<double>& walk,
                       double& ra, double& rweight)
  {
    walk.x = 0;
    walk.y = speedY / walkMaxForwardSpeed;
    rweight=0;
  }
};

}

#endif //__DDD2004Rules_WalkY_h_


/*
* Change log:
*
* $Log: WalkY.h,v $
* Revision 1.3  2004/03/08 01:06:47  roefer
* Interfaces should be const
*
* Revision 1.2  2003/10/31 08:32:48  dueffert
* doxygen bugs fixed
*
* Revision 1.1  2003/10/26 22:49:38  loetzsch
* created ATH2004BehaviorControl from GT2003BehaviorControl
*  - strongly simplified option graph
*  - moved some symbols from GT2003 to CommonXabsl2Symbols
*  - moved some basic behaviors from GT2003 to CommonXabsl2BasicBehaviors
*
* cloned ATH2004 three times (BB2004, DDD2004, MSH2004)
*
*/
