/** 
* @file SpecialVisionSymbols.cpp
*
* Implementation of class SpecialVisionSymbols.
*
* @author Matthias Jngel
*/

#include "SpecialVisionSymbols.h"

SpecialVisionSymbols::SpecialVisionSymbols(const BehaviorControlInterfaces& interfaces)
: BehaviorControlInterfaces(interfaces)
{
}


void SpecialVisionSymbols::registerSymbols(Xabsl2Engine& engine)
{
  // "special-vision-request"
  engine.registerEnumeratedOutputSymbol("special-vision-request",(int*)&specialVisionRequest.specialVisionRequest);
  engine.registerEnumeratedOutputSymbolEnumElement("special-vision-request","none",SpecialVisionRequest::none);
  engine.registerEnumeratedOutputSymbolEnumElement("special-vision-request","bar-code",SpecialVisionRequest::barCode);

  // "bar-code"
  engine.registerEnumeratedInputSymbol("bar-code",this,
    (int (Xabsl2FunctionProvider::*)())&SpecialVisionSymbols::getBarCodeValue);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.undefined",-1);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.zero",0);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.one",1);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.two",2);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.three",3);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.four",4);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.five",5);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.six",6);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.seven",7);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.eight",8);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.nine",9);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.ten",10);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.eleven",11);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.twelve",12);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.thirteen",13);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.fourteen",14);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.fifteen",15);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.sixteen",16);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.seventeen",17);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.eighteen",18);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.nineteen",19);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.twenty",20);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.twenty-one",21);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.twenty-two",22);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.twenty-three",23);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.twenty-four",24);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.twenty-five",25);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.twenty-six",26);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.twenty-seven",27);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.twenty-eight",28);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.twenty-nine",29);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.thirty",30);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.thirty-one",31);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.thirty-two",32);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.thirty-three",33);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.thirty-four",34);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.thirty-five",35);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.thirty-six",36);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.thirty-seven",37);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.thirty-eight",38);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.thirty-nine",39);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.forty",40);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.forty-one",41);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.forty-two",42);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.forty-three",43);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.forty-four",44);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.forty-five",45);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.forty-six",46);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.forty-seven",47);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.forty-eight",48);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.forty-nine",49);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.fifty",50);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.fifty-one",51);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.fifty-two",52);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.fifty-three",53);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.fifty-four",54);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.fifty-five",55);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.fifty-six",56);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.fifty-seven",57);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.fifty-eight",58);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.fifty-nine",59);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.sixty",60);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.sixty-one",61);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.sixty-two",62);
  engine.registerEnumeratedInputSymbolEnumElement("bar-code","bar-code.sixty-three",63);
}

void SpecialVisionSymbols::update()
{
}

int SpecialVisionSymbols::getBarCodeValue()
{
  return specialPercept.barCodeId;
}

/*
* Change Log
* 
* $Log: SpecialVisionSymbols.cpp,v $
* Revision 1.2  2004/03/08 00:58:59  roefer
* Interfaces should be const
*
* Revision 1.1  2003/10/22 22:18:44  loetzsch
* prepared the cloning of the GT2003BehaviorControl
*
* Revision 1.1  2003/10/06 13:39:29  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.1  2003/05/07 17:54:46  juengel
* Added missing symbols to GT2003BehaviorControl.
*
*/

