/** 
* @file RobotStateSymbols.h
*
* Declaration of class RobotStateSymbols.
*
* @author Matthias Jngel
*/

#ifndef __RobotStateSymbols_h_
#define __RobotStateSymbols_h_

#include "../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"

/**
* The Xabsl2 symbols that are defined in "robot-state-symbols.xml"
*
* @author Matthias Jngel
*/ 
class RobotStateSymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
public:
/*
* Constructor.
* @param interfaces The paramters of the BehaviorControl module.
  */
  RobotStateSymbols(const BehaviorControlInterfaces& interfaces);
  
  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);
  
    /** updates the symbols */
  void update();

  //!@name Input symbols
  //!@{
  int getSwitches(); /*!< A function for the symbol "self.switches" */
  int getTailPosition(); /*!< A function for the symbol "self.tail-position" */
  int getMouthState();  /*!< A function for the symbol "self.mouth-state" */
  bool getCollisionFrontLeft();  /*!< A function for the symbol "self.collision-front-left" */
  bool getCollisionFrontRight();  /*!< A function for the symbol "self.collision-front-right" */
  bool getCollisionHindLeft();  /*!< A function for the symbol "self.collision-hind-left" */
  bool getCollisionHindRight();  /*!< A function for the symbol "self.collision-hind-right" */
  bool getCollisionHead();  /*!< A function for the symbol "self.collision-head" */
  bool getCollisionAggregate();  /*!< A function for the symbol "self.collision-aggregate" */
  bool getBallUnderHead(); /*!< A function for the symbol "self.ball-under-head" */
  double getConsecutiveCollisionTimeFrontLeft();  /*!< A function for the symbol "self.consecutive-collision-time-front-left" */
  double getConsecutiveCollisionTimeFrontRight();  /*!< A function for the symbol "self.consecutive-collision-time-front-right" */
  double getConsecutiveCollisionTimeHindLeft();  /*!< A function for the symbol "self.consecutive-collision-time-hind-left" */
  double getConsecutiveCollisionTimeHindRight();  /*!< A function for the symbol "self.consecutive-collision-time-hind-right" */
  double getConsecutiveCollisionTimeHead();  /*!< A function for the symbol "self.consecutive-collision-time-head" */
  double getConsecutiveCollisionTimeAggregate();  /*!< A function for the symbol "self.consecutive-collision-time-aggregate" */
  double getSwitchesPressedTime(); /*!< A function for the symbol "self.switches.pressed-time" */
  double getCurrentSystemTime(); /*!< A function for the symbol "robot-state.system-time" */
  double getRemainingCapacity(); /*!< A function for the symbol "robot-state.remaining-capacity" */
  //!@}
};


#endif // __RobotStateSymbols_h_

/*
* Change Log
* 
* $Log: RobotStateSymbols.h,v $
* Revision 1.3  2004/04/08 15:33:01  wachter
* GT04 checkin of Microsoft-Hellounds
*
* Revision 1.2  2004/03/08 00:58:58  roefer
* Interfaces should be const
*
* Revision 1.1  2003/10/22 22:18:44  loetzsch
* prepared the cloning of the GT2003BehaviorControl
*
* Revision 1.1  2003/10/06 13:39:29  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.3  2003/08/09 14:56:09  dueffert
* symbol remaining-capacity added
*
* Revision 1.2  2003/07/06 12:33:05  dueffert
* robot.state-system.time added
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.3  2003/06/20 10:32:27  goehring
* Added CollisionStateSymbols
*
* Revision 1.2  2003/06/10 15:09:07  goehring
* Collision-Detector Xabsl symbols added
*
* Revision 1.1  2003/05/07 17:54:46  juengel
* Added missing symbols to GT2003BehaviorControl.
*
*/

