/** 
* @file MotionRequestSymbols.cpp
*
* Declaration of class MotionRequestSymbols.
*
* @author Max Risler
*/

#include "MotionRequestSymbols.h"
#include "Tools/Math/Geometry.h"
#include "Tools/StringFunctions.h"

MotionRequestSymbols::MotionRequestSymbols(const BehaviorControlInterfaces& interfaces)
: BehaviorControlInterfaces(interfaces)
{
}

void MotionRequestSymbols::registerSymbols(Xabsl2Engine &engine)
{
  char s[256];
  int i;
  
  
  // "executed-motion-request.motion-type"
  engine.registerEnumeratedInputSymbol("executed-motion-request.motion-type",(const int*)&(executedMotionRequest.motionType));
  for (i=0;i<MotionRequest::numOfMotion;i++)
  {
    getXmlString(s,MotionRequest::getMotionName((MotionRequest::MotionID)i));
    engine.registerEnumeratedInputSymbolEnumElement("executed-motion-request.motion-type",s,i);
  }

  // "executed-motion-request.walk-type"
  engine.registerEnumeratedInputSymbol("executed-motion-request.walk-type",(const int*)&(executedMotionRequest.walkType));
  for (i=0;i<MotionRequest::numOfWalkType;i++)
  {
    getXmlString(s,MotionRequest::getWalkTypeName((MotionRequest::WalkType)i));
    engine.registerEnumeratedInputSymbolEnumElement("executed-motion-request.walk-type",s,i);
  }

  // "executed-motion-request.special-action-type"
  engine.registerDecimalInputSymbol("executed-motion-request.special-action-type",this,
    (double (Xabsl2FunctionProvider::*)())&MotionRequestSymbols::getExecutedSpecialActionType);
}

double MotionRequestSymbols::getExecutedSpecialActionType()
{
  return (double)executedMotionRequest.specialActionType;
}

/*
* Change Log
* 
* $Log: MotionRequestSymbols.cpp,v $
* Revision 1.2  2004/03/08 00:58:56  roefer
* Interfaces should be const
*
* Revision 1.1  2003/10/22 22:18:44  loetzsch
* prepared the cloning of the GT2003BehaviorControl
*
* Revision 1.1  2003/10/06 13:39:28  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.3  2003/07/07 15:02:33  cesarz
* added input symbol dribble.speed-y
*
* Revision 1.2  2003/07/03 18:39:30  risler
* do-kick option added
* all kicks use do-kick
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.5  2003/05/12 00:03:29  dueffert
* doxygen bugs fixed
*
* Revision 1.4  2003/05/08 10:20:35  dueffert
* bugs fixed
*
* Revision 1.3  2003/05/08 00:22:29  risler
* removed symbol executed-motion-request.ball-caught
*
* Revision 1.2  2003/05/07 17:29:10  risler
* added MotionRequestSymbols
*
*
*/

