/** 
* @file LEDAndSoundSymbols.h
*
* Declaration of class LEDAndSoundSymbols.
*
* @author Uwe Dffert
* @author Martin Ltzsch
*/

#ifndef __LEDAndSoundSymbols_h_
#define __LEDAndSoundSymbols_h_

#include "../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"

/**
* The Xabsl2 symbols that are defined in "led-and-sound-symbols.xml"
*
* @author Uwe Dffert
* @author Martin Ltzsch
*/ 
class LEDAndSoundSymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
public:
/*
* Constructor.
* @param interfaces The paramters of the BehaviorControl module.
  */
  LEDAndSoundSymbols(const BehaviorControlInterfaces& interfaces);
  
  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);
};


#endif // __LEDAndSoundSymbols_h_

/*
* Change Log
* 
* $Log: LEDAndSoundSymbols.h,v $
* Revision 1.2  2004/03/08 00:58:56  roefer
* Interfaces should be const
*
* Revision 1.1  2003/10/22 22:18:44  loetzsch
* prepared the cloning of the GT2003BehaviorControl
*
* Revision 1.1  2003/10/06 13:39:28  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.1  2003/05/06 14:46:12  loetzsch
* added registration of generated GT2003BehaviorControl symbols
*
*/

