/** 
* @file JoystickSymbols.cpp
*
* Implementation of class JoystickSymbols.
*
* @author Matthias Jngel
*/

#include "JoystickSymbols.h"

JoystickSymbols::JoystickSymbols(const BehaviorControlInterfaces& interfaces)
: BehaviorControlInterfaces(interfaces)
{
}


void JoystickSymbols::registerSymbols(Xabsl2Engine& engine)
{
  // "joystick-data.x"
  engine.registerDecimalInputSymbol("joystick-data.x",&(joystickData.x));
  // "joystick-data.y"
  engine.registerDecimalInputSymbol("joystick-data.y",&(joystickData.y));
  // "joystick-data.z"
  engine.registerDecimalInputSymbol("joystick-data.z",&(joystickData.z));
  // "joystick-data.accel"
  engine.registerDecimalInputSymbol("joystick-data.accel",&(joystickData.accel));
  // "joystick-data.button"
  engine.registerEnumeratedInputSymbol("joystick-data.button",this,
    (int (Xabsl2FunctionProvider::*)())&JoystickSymbols::getJoystickButton);
  engine.registerEnumeratedInputSymbolEnumElement("joystick-data.button","no-button",0);
  //numOfJostickButtons-times
  engine.registerEnumeratedInputSymbolEnumElement("joystick-data.button","button1",1);
  engine.registerEnumeratedInputSymbolEnumElement("joystick-data.button","button2",2);
  engine.registerEnumeratedInputSymbolEnumElement("joystick-data.button","button3",3);
  engine.registerEnumeratedInputSymbolEnumElement("joystick-data.button","button4",4);
  engine.registerEnumeratedInputSymbolEnumElement("joystick-data.button","button5",5);
  engine.registerEnumeratedInputSymbolEnumElement("joystick-data.button","button6",6);
  engine.registerEnumeratedInputSymbolEnumElement("joystick-data.button","button7",7);
  engine.registerEnumeratedInputSymbolEnumElement("joystick-data.button","button8",8);
  engine.registerEnumeratedInputSymbolEnumElement("joystick-data.button","button9",9);
  engine.registerEnumeratedInputSymbolEnumElement("joystick-data.button","button10",10);
  engine.registerEnumeratedInputSymbolEnumElement("joystick-data.button","button11",11);
  engine.registerEnumeratedInputSymbolEnumElement("joystick-data.button","button12",12);
  // "joystick-data.coolie"
  engine.registerEnumeratedInputSymbol("joystick-data.coolie",(const int*)&(joystickData.coolie));
  engine.registerEnumeratedInputSymbolEnumElement("joystick-data.coolie","no-coolie",0);
  engine.registerEnumeratedInputSymbolEnumElement("joystick-data.coolie","N",1);
  engine.registerEnumeratedInputSymbolEnumElement("joystick-data.coolie","NE",2);
  engine.registerEnumeratedInputSymbolEnumElement("joystick-data.coolie","E",3);
  engine.registerEnumeratedInputSymbolEnumElement("joystick-data.coolie","SE",4);
  engine.registerEnumeratedInputSymbolEnumElement("joystick-data.coolie","S",5);
  engine.registerEnumeratedInputSymbolEnumElement("joystick-data.coolie","SW",6);
  engine.registerEnumeratedInputSymbolEnumElement("joystick-data.coolie","W",7);
  engine.registerEnumeratedInputSymbolEnumElement("joystick-data.coolie","NW",8);
  // "joystick-data.direct-special-action"
  engine.registerBooleanInputSymbol("joystick-data.direct-special-action",&(joystickData.directSpecialAction));
  // "joystick-data.special-action-id"
  engine.registerDecimalInputSymbol("joystick-data.special-action-id",this,
    (double (Xabsl2FunctionProvider::*)())&JoystickSymbols::getSpecialActionId);
  // "joystick-data.time-since-last-message"
  engine.registerDecimalInputSymbol("joystick-data.time-since-last-message",this,
    (double (Xabsl2FunctionProvider::*)())&JoystickSymbols::getJoystickTimeSinceLastMessage);
}

void JoystickSymbols::update()
{
}


double JoystickSymbols::getJoystickTimeSinceLastMessage()
{
  return (double)SystemCall::getTimeSince(joystickData.timeStamp);
}

int JoystickSymbols::getJoystickButton()
{
  for (int i=0;i<numOfJoystickButtons;i++)
  {
    if ((joystickData.button >> i)&1)
    {
      //the button with the lowest number has the highest priority
      return i+1;
    }
  }
  return 0;
}

double JoystickSymbols::getSpecialActionId()
{
  return (double)joystickData.specialActionID;
}

/*
* Change Log
* 
* $Log: JoystickSymbols.cpp,v $
* Revision 1.3  2004/04/26 15:58:59  thomas
* added new project RobotRemote based on ATHAiboControl
*
* Revision 1.2  2004/03/08 00:58:56  roefer
* Interfaces should be const
*
* Revision 1.1  2003/10/22 22:18:44  loetzsch
* prepared the cloning of the GT2003BehaviorControl
*
* Revision 1.1  2003/10/06 13:39:28  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.1  2003/05/07 17:54:40  juengel
* Added missing symbols to GT2003BehaviorControl.
*
*/

