/** 
* @file HeadAndTailSymbols.cpp
*
* Implementation of class HeadAndTailSymbols.
*
* @author Uwe Dffert
* @author Martin Ltzsch
*/

#include "HeadAndTailSymbols.h"
#include "Tools/StringFunctions.h"

HeadAndTailSymbols::HeadAndTailSymbols(const BehaviorControlInterfaces& interfaces)
: BehaviorControlInterfaces(interfaces)
{
}


void HeadAndTailSymbols::registerSymbols(Xabsl2Engine& engine)
{
  int i;
  char s[256];

  // "head-control-mode"
  engine.registerEnumeratedOutputSymbol("head-control-mode",(int*)&headControlMode);
  for (i=0;i<HeadControlMode::numOfHeadControlModes;i++)
  {
    sprintf(s,"head-control-mode.");
    getXmlString(s+strlen(s),HeadControlMode::getHeadControlModeName((HeadControlMode::HeadControlModes)i));
    engine.registerEnumeratedOutputSymbolEnumElement("head-control-mode",s,i);
  }

  // "tail-mode"
  engine.registerEnumeratedOutputSymbol("tail-mode",(int*)&motionRequest.tailRequest);
  for (i=0;i<MotionRequest::numOfTailRequests;i++)
  {
    sprintf(s,"tail-mode.");
    getXmlString(s+strlen(s),MotionRequest::getTailRequestName((MotionRequest::TailRequest)i));
    engine.registerEnumeratedOutputSymbolEnumElement("tail-mode",s,i);
  }
}


/*
* Change Log
* 
* $Log: HeadAndTailSymbols.cpp,v $
* Revision 1.2  2004/03/08 00:58:55  roefer
* Interfaces should be const
*
* Revision 1.1  2003/10/22 22:18:44  loetzsch
* prepared the cloning of the GT2003BehaviorControl
*
* Revision 1.1  2003/10/06 13:39:28  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.1  2003/05/06 14:46:12  loetzsch
* added registration of generated GT2003BehaviorControl symbols
*
*/

