/** 
* @file CalibrationSymbols.h
*
* Declaration of class CalibrationSymbols.
*
* @author Matthias Jngel
*/

#ifndef __CalibrationSymbols_h_
#define __CalibrationSymbols_h_

#include "../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"

/**
* The Xabsl2 symbols that are defined in "calibration-symbols.xml"
*
* @author Matthias Jngel
*/ 

class CalibrationSymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
public:
/*
* Constructor.
* @param interfaces The paramters of the BehaviorControl module.
  */
  CalibrationSymbols(const BehaviorControlInterfaces& interfaces);
  
  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);

private:
};




#endif // __CalibrationSymbols_h_

/*
* Change Log
* 
* $Log: CalibrationSymbols.h,v $
* Revision 1.1  2004/03/21 12:37:29  juengel
* Moved calibration symbols to common symbols.
*
* Revision 1.3  2004/03/08 01:06:58  roefer
* Interfaces should be const
*
* Revision 1.2  2003/10/22 22:18:47  loetzsch
* prepared the cloning of the GT2003BehaviorControl
*
* Revision 1.1  2003/10/12 11:44:58  juengel
* Added CalibrationRequest.
*
*/

