/**
* @file BehaviorControlSelector.h
* 
* Definition of class BehaviorControlSelector
*
* @author Max Risler
* @author Martin Ltzsch
* @author Matthias Jngel
*/

#ifndef __BehaviorControlSelector_h_
#define __BehaviorControlSelector_h_

#include "Tools/Module/ModuleSelector.h"

#include "BehaviorControl.h"
#include "GT2003BehaviorControl/GT2003BehaviorControl.h"
#include "ATH2004BehaviorControl/ATH2004BehaviorControl.h"
#include "ATH2004ERS7BehaviorControl/ATH2004ERS7BehaviorControl.h"
#include "BB2004BehaviorControl/BB2004BehaviorControl.h"
#include "DDD2004BehaviorControl/DDD2004BehaviorControl.h"
#include "MSH2004BehaviorControl/MSH2004BehaviorControl.h"
#include "MotionRatingBehaviorControl/MotionRatingBehaviorControl.h"
#include "MotionRatingBehaviorControl/MotionRating2BehaviorControl.h"

/**
* BehaviorControl selection module.
*
* A selector for behavior control modules.
*/
class BehaviorControlSelector : public ModuleSelector, public BehaviorControlInterfaces
{
public:
/**
* Constructor.
* @param handler The module handler of the process.
* @param interfaces The paramters of the BehaviorControl module.
  */
  BehaviorControlSelector(ModuleHandler &handler, const BehaviorControlInterfaces& interfaces)
    : ModuleSelector(SolutionRequest::behaviorControl),
    BehaviorControlInterfaces(interfaces)
  {
    handler.setModuleSelector(SolutionRequest::behaviorControl, this);
  }
  
  
  /** 
  * Is called on start and when the selected solution changes
  * to create a specific solution.
  * @param id The id of the solution to create
  * @return The created solution or 0
  */
  virtual Module* createSolution(SolutionRequest::ModuleSolutionID id)
  {
    switch(id)
    {
    case SolutionRequest::gt2003BehaviorControlAgentSoccer:
      return new Xabsl2BehaviorControlAgentInterface("soccer",new GT2003BehaviorControl(*this),*this);
      
    case SolutionRequest::gt2003BehaviorControlAgentPenaltyShooter:
      return new Xabsl2BehaviorControlAgentInterface("penalty-shooter",new GT2003BehaviorControl(*this),*this);
      
    case SolutionRequest::gt2003BehaviorControlAgentManualKick:
      return new Xabsl2BehaviorControlAgentInterface("manual-kick",new GT2003BehaviorControl(*this),*this);
      
    case SolutionRequest::gt2003BehaviorControlAgentDemo:
      return new Xabsl2BehaviorControlAgentInterface("demo",new GT2003BehaviorControl(*this),*this);
      
    case SolutionRequest::gt2003BehaviorControlAgentEvolution:
      return new Xabsl2BehaviorControlAgentInterface("evolution",new GT2003BehaviorControl(*this),*this);
      
    case SolutionRequest::gt2003BehaviorControlAgentJoystickControlled:
      return new Xabsl2BehaviorControlAgentInterface("joystick-controlled",new GT2003BehaviorControl(*this),*this);
      
    case SolutionRequest::ath2004BehaviorControlAgentSoccer:
      return new Xabsl2BehaviorControlAgentInterface("soccer",new ATH2004BehaviorControl(*this),*this);
      
    case SolutionRequest::ath2004BehaviorControlAgentAnotherGoalie:
      return new Xabsl2BehaviorControlAgentInterface("another-goalie",new ATH2004BehaviorControl(*this),*this);

    case SolutionRequest::ath2004BehaviorControlAgentOlliKahn:
      return new Xabsl2BehaviorControlAgentInterface("olli-kahn",new ATH2004BehaviorControl(*this),*this);

    case SolutionRequest::ath2004BehaviorControlAgentDevelopAnotherGoalie1:
      return new Xabsl2BehaviorControlAgentInterface("develop-another-goalie1",new ATH2004BehaviorControl(*this),*this);

    case SolutionRequest::ath2004BehaviorControlAgentPenaltyShooter:
      return new Xabsl2BehaviorControlAgentInterface("penalty-shooter",new ATH2004BehaviorControl(*this),*this);
      
    case SolutionRequest::ath2004BehaviorControlAgentPenaltyShooterHertha:
      return new Xabsl2BehaviorControlAgentInterface("penalty-shooter-hertha",new ATH2004BehaviorControl(*this),*this);
      
    case SolutionRequest::ath2004BehaviorControlAgentPenaltyShooterUnion:
      return new Xabsl2BehaviorControlAgentInterface("penalty-shooter-union",new ATH2004BehaviorControl(*this),*this);
      
    case SolutionRequest::ath2004BehaviorControlAgentPerceptTester:
      return new Xabsl2BehaviorControlAgentInterface("percept-tester",new ATH2004BehaviorControl(*this),*this);

    //viviana+michael
    case SolutionRequest::ath2004BehaviorControlAgentPassTester:
      return new Xabsl2BehaviorControlAgentInterface("pass-tester",new ATH2004BehaviorControl(*this),*this);    

    case SolutionRequest::ath2004BehaviorControlAgentInterceptTester:
      return new Xabsl2BehaviorControlAgentInterface("intercept-tester",new ATH2004BehaviorControl(*this),*this);
    
    case SolutionRequest::ath2004BehaviorControlAgentJoystickControlled:
      return new Xabsl2BehaviorControlAgentInterface("joystick-controlled",new ATH2004BehaviorControl(*this),*this);
      
    case SolutionRequest::ath2004ERS7BehaviorControlAgentPenaltyShooter:
      return new Xabsl2BehaviorControlAgentInterface("penalty-shooter",new ATH2004ERS7BehaviorControl(*this),*this);
      
    case SolutionRequest::ath2004ERS7BehaviorControlAgentSoccer:
      return new Xabsl2BehaviorControlAgentInterface("soccer",new ATH2004ERS7BehaviorControl(*this),*this);
      
    case SolutionRequest::ath2004ERS7BehaviorControlAgentKickTest:
      return new Xabsl2BehaviorControlAgentInterface("kick-test",new ATH2004ERS7BehaviorControl(*this),*this);
      
    case SolutionRequest::ath2004ERS7BehaviorControlAgentMLPassTest:
      return new Xabsl2BehaviorControlAgentInterface("ml-pass-test",new ATH2004ERS7BehaviorControl(*this),*this);

    case SolutionRequest::ath2004ERS7BehaviorControlAgentMLDemo:
      return new Xabsl2BehaviorControlAgentInterface("ml-demo",new ATH2004ERS7BehaviorControl(*this),*this);

    case SolutionRequest::bb2004BehaviorControlAgentSoccer:
      return new Xabsl2BehaviorControlAgentInterface("soccer",new BB2004BehaviorControl(*this),*this);
      
    case SolutionRequest::bb2004BehaviorControlAgentPenaltyShooter:
      return new Xabsl2BehaviorControlAgentInterface("penalty-shooter",new BB2004BehaviorControl(*this),*this);
      
    case SolutionRequest::ddd2004BehaviorControlAgentSoccer:
      return new Xabsl2BehaviorControlAgentInterface("soccer",new DDD2004BehaviorControl(*this),*this);
      
    case SolutionRequest::ddd2004BehaviorControlAgentPenaltyShooter:
      return new Xabsl2BehaviorControlAgentInterface("penalty-shooter",new DDD2004BehaviorControl(*this),*this);
      
    case SolutionRequest::ddd2004BehaviorControlAgentDemo:
      return new Xabsl2BehaviorControlAgentInterface("demo",new DDD2004BehaviorControl(*this),*this);
      
    case SolutionRequest::motionRatingBehaviorControl:
	    return new MotionRatingBehaviorControl(*this);

	  case SolutionRequest::motionRating2BehaviorControl:
	    return new MotionRating2BehaviorControl(*this);

    case SolutionRequest::msh2004BehaviorControlAgentSoccer:
      return 0; //new Xabsl2BehaviorControlAgentInterface("soccer",new MSH2004BehaviorControl(*this),*this);
      
    case SolutionRequest::msh2004BehaviorControlAgentDTTSoccer:
      return 0; //new Xabsl2BehaviorControlAgentInterface("dtt-soccer",new MSH2004BehaviorControl(*this),*this);
      
    case SolutionRequest::msh2004BehaviorControlAgentPenaltyShooter:
      return 0; //new Xabsl2BehaviorControlAgentInterface("penalty-shooter",new MSH2004BehaviorControl(*this),*this);
      
    case SolutionRequest::msh2004BehaviorControlAgentGlassBoxDemo:
      return new Xabsl2BehaviorControlAgentInterface("glassbox-demo",new MSH2004BehaviorControl(*this),*this);
      
    case SolutionRequest::msh2004BehaviorControlAgentKickengineTraining:
      return 0; //new Xabsl2BehaviorControlAgentInterface("kickengine-training",new MSH2004BehaviorControl(*this),*this);

    case SolutionRequest::msh2004BehaviorControlAgentAutonomousEvolution:
      return new Xabsl2BehaviorControlAgentInterface("autonomous-evolution",new MSH2004BehaviorControl(*this),*this);

    case SolutionRequest::msh2004BehaviorControlAgentTest:
      return new Xabsl2BehaviorControlAgentInterface("test",new MSH2004BehaviorControl(*this),*this);

    default:
      return 0;
    }
  }
  
};

#endif // __BehaviorControlSelector_h_

/*
* Change log :
* 
* $Log: BehaviorControlSelector.h,v $
* Revision 1.35  2004/06/03 10:24:36  schumann
* removed unused options and speeded up xabsl compiling by factor 5
*
* Revision 1.34  2004/05/23 00:03:59  loetzsch
* removed GT2004BehaviorControl and GT2004HeadControl
*
* Revision 1.33  2004/05/14 11:37:08  loetzsch
* support for multiple xabsl2engines in different modules
* preliminary GT2004HeadControl (does not work at all)
*
* Revision 1.32  2004/05/06 15:40:17  loetzsch
* yet another demo agent
*
* Revision 1.31  2004/05/05 21:47:13  kerdels
* added agent for the open challenge
*
* Revision 1.30  2004/05/02 13:34:26  juengel
* Added GT2004BehaviorControl.
*
* Revision 1.29  2004/04/27 11:23:23  loetzsch
* preliminary passing experiments
*
* Revision 1.28  2004/04/26 15:58:59  thomas
* added new project RobotRemote based on ATHAiboControl
*
* Revision 1.27  2004/04/08 15:33:00  wachter
* GT04 checkin of Microsoft-Hellounds
*
* Revision 1.26  2004/04/07 13:25:43  thomas
* ddd checkin after go04 - second part fixed solutions
*
* Revision 1.24  2004/03/17 16:18:49  thomas
* added preversion of motion optimisation with behaviour, selflocator, headcontrol and robotcontrol dialog
*
* Revision 1.23  2004/03/16 14:00:17  juengel
* Integrated Improvments from "Gnne"
* -ATH2004ERS7Behavior
* -ATHHeadControl
* -KickSelectionTable
* -KickEditor
*
* Revision 1.22  2004/03/08 00:58:52  roefer
* Interfaces should be const
*
* Revision 1.3  2004/03/16 08:34:25  loetzsch
* moved agent kick-test from ATH2004 to ATH2004ERS7
*
* Revision 1.2  2004/03/06 18:31:21  loetzsch
* cloned ATH2004BehaviorControl into ATH2004ERS7BehaviorControl
*
* Revision 1.1.1.1  2004/03/05 10:10:11  loetzsch
* created local cvs for Gnne
*
* Revision 1.21  2004/02/26 18:07:27  cesarz
* first version of evolution behavior
*
* Revision 1.20  2004/02/23 12:52:57  schumann
* added MSH2004KickEngine
*
* Revision 1.19  2004/02/16 00:52:56  rempe
* agent for developing another goalie
*
* Revision 1.18  2004/02/10 17:51:54  goetzke
* added pass-player
*
* Revision 1.17  2004/02/08 10:43:19  witzmann
* <!DOCTYPE symbol-and-basic-behavior-files SYSTEM "../symbol-and-basic-behavior-files.dtd">
*
* Revision 1.16  2004/02/05 14:22:14  spranger
* added intercept-tester agent
*
* Revision 1.15  2004/02/05 10:31:44  juengel
* tags added
*
* Revision 1.14  2004/01/24 14:55:29  loetzsch
* created ATH AiboControl
*
* Revision 1.13  2004/01/21 14:31:58  loetzsch
* Module Selectors create only the selected solution.
* When the solution changes, the old solution is erased and the new
* one ist created using createSolution(..)
*
* Revision 1.12  2004/01/08 13:53:37  loetzsch
* new kick test behaviors
*
* Revision 1.11  2004/01/06 17:49:41  sombrutz
* added another-goalie (Dirk Rempe (rempe@informatik.hu-berlin.de) , Robert Sombrutzki (sombrutz@informatik.hu-berlin.de), Erik Witzmann)
*
* Revision 1.10  2003/12/19 01:14:14  kerdels
* agent added
*
* Revision 1.9  2003/12/11 16:18:42  risler
* added agent DDD2004-demo
*
* Revision 1.8  2003/12/11 11:25:59  seva
* Added penalty-shooter-union and penalty-shooter-hertha.
*
* Revision 1.7  2003/11/03 20:12:19  juengel
* Added ath-percept-tester
*
* Revision 1.6  2003/10/27 13:27:03  wachter
* Added agent for glass-box demo.
*
* Revision 1.5  2003/10/26 22:49:34  loetzsch
* created ATH2004BehaviorControl from GT2003BehaviorControl
*  - strongly simplified option graph
*  - moved some symbols from GT2003 to CommonXabsl2Symbols
*  - moved some basic behaviors from GT2003 to CommonXabsl2BasicBehaviors
*
* cloned ATH2004 three times (BB2004, DDD2004, MSH2004)
*
* Revision 1.4  2003/10/22 22:18:44  loetzsch
* prepared the cloning of the GT2003BehaviorControl
*
* Revision 1.3  2003/07/30 14:50:43  dueffert
* walk evolution agent added
*
* Revision 1.2  2003/07/07 22:45:34  thomas
* added: frame for penalty-shooter agent
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.38  2003/06/23 13:36:38  loetzsch
* renamed GT2003 Agent turn-and-kick-test to kick-test
*
* Revision 1.37  2003/06/13 17:03:47  juengel
* Added challenge agents and options.
*
* Revision 1.36  2003/06/06 10:55:19  dueffert
* demo agent added
*
* Revision 1.35  2003/06/02 09:07:49  loetzsch
* added option turn-and-kick and agent turn-and-kick-test
*
* Revision 1.34  2003/05/27 15:32:06  loetzsch
* added agent manual-kick
*
* Revision 1.33  2003/05/27 06:54:08  thiel
* re-enabled Ruhrpott-Hellhounds-Behavior-Control
*
* Revision 1.32  2003/05/26 16:35:38  thiel
* temporarily disabled Ruhrpott-Hellhounds-Behavior-Control
*
* Revision 1.31  2003/05/15 15:24:37  risler
* added agent obstacle-avoider
*
* Revision 1.30  2003/05/06 16:02:31  loetzsch
* added agent free-part-of-opponent-goal-test
*
* Revision 1.29  2003/05/06 13:54:22  pruente
* added collective-soccer agent
*
* Revision 1.28  2003/05/03 15:14:02  loetzsch
* GT2003BehaviorControl first draft
*
* Revision 1.27  2003/04/16 14:01:30  loetzsch
* removed Xabsl 1 from GT2003
*
* Revision 1.26  2003/04/15 17:19:43  risler
* moved DDDGO2003 ImageProcessor to own module
* removed ContinuousBasicBehaviorTester
*
* Revision 1.25  2003/04/15 15:52:12  risler
* DDD GO 2003 code integrated
*
* Revision 1.21  2003/04/09 16:22:55  max
* added continuous-test agent
*
* Revision 1.19  2003/04/05 17:02:41  max
* added localization-test agent
* added tailcontrol option
*
* Revision 1.24  2003/04/14 16:14:13  loetzsch
* ATH after GermanOpen CVS merge
* added penalty player
*
* Revision 1.23  2003/04/06 20:59:13  roefer
* BremenByters behavior reenabled. If robot crashes, rebuild all!
*
* Revision 1.22  2003/04/03 16:49:19  loetzsch
* BremenByters wieder auskommentiert
*
* Revision 1.21  2003/04/03 15:47:55  tim
* BremenByters wieder einkommentiert
*
* Revision 1.20  2003/04/03 12:27:41  schumann
* Bremen auskommentiert. Siehe Newsgroup (Verhalten).
*
* Revision 1.19  2003/04/02 16:38:19  cesarz
* merged local and tamara files
*
* Revision 1.18  2003/03/30 14:10:35  juengel
* Added BarCodeSwitcher
*
* Revision 1.17  2003/03/12 12:14:12  risler
* added DDD-walk-test
*
* Revision 1.16  2003/03/04 14:30:06  kallnik
* continuousbasicbehvior: bug fixes
*
* Revision 1.15  2003/02/28 15:03:58  loetzsch
* temporarily removed creation of RuhrpottHellhoundsBehaviorControl,
* it produced too much memory leaks. (more than 200)
*
* Revision 1.14  2003/02/25 11:51:15  loetzsch
* no message
*
* Revision 1.13  2003/02/24 14:48:17  kallnik
* some bugs in continuousbasicbehaviors fixed
*
* Revision 1.12  2003/02/20 13:22:00  kallnik
* error correction
*
* Revision 1.11  2003/02/20 12:40:24  kallnik
* added continuousBasicBehaviorTester in behaviorSelector
*
* Revision 1.10  2003/02/07 16:40:50  dueffert
* Bombay stuff added after cleanup
*
* Revision 1.9  2003/01/23 15:22:17  dueffert
* new xabsl2 agent added
*
* Revision 1.8  2003/01/21 18:10:12  risler
* added agent simple-follow-ball
*
* Revision 1.7  2003/01/20 12:19:58  juengel
* Added BremenBytersBehaviorControl
* and RuhrpottHellhoundsBehaviorControl.
*
* Revision 1.6  2003/01/19 22:57:09  loetzsch
* cloned Humboldt2003BehaviorControl to
* DarmstadtDribblingDackelsBehaviorControl
*
* Revision 1.5  2003/01/19 13:04:51  loetzsch
* xabsl2 agents now can be changed by using the Module and SolutionRequest
* mechanism
*
* Revision 1.4  2002/11/30 19:11:43  juengel
* Moved BehaviorControl solution Xabsl2Berlin to Humboldt2003.
*
* Revision 1.3  2002/11/18 17:16:29  loetzsch
* Added a new BehaviorControl solution: Xabsl2BerlinBehaviorControl
* When it works, it shall be cloned to the BehaviorControl solutions for
* the other univiersities
*
* Revision 1.2  2002/09/12 12:24:10  juengel
* continued change of module/solution mechanisms
*
* Revision 1.1  2002/09/10 15:36:12  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.9  2002/08/28 12:37:37  petters
* TUDXMLBehavior moved to /src/modules/behaviorcontrol/tudxmlbehavior
*
* Revision 1.8  2002/08/22 14:41:04  risler
* added some doxygen comments
*
* Revision 1.7  2002/08/21 11:50:44  cesarz
* GT2001PlayersPerceptor, BerlinSelfLocator, GT2001WalkingEngine,
* DoWalkingEngine, FuzzyBehaviorControl, BremenGOBehaviorControl,
* FuzzyBehaviortesterdlgbar and Behaviortesterdlgbar removed.
*
* Revision 1.6  2002/07/23 13:33:40  loetzsch
* new streaming classes
*
* removed many #include statements
*
* Revision 1.5  2002/06/20 00:40:20  Thomas Rfer
* WLan crash removed
*
* Revision 1.4  2002/06/09 15:24:51  loetzsch
* Added TeamMessageCollection and BehaviorTeamMessage to the execute of BehaviorControl
*
* Revision 1.3  2002/05/16 13:29:44  tim
* Added BallChallengeBehavior
*
* Revision 1.2  2002/05/10 17:29:01  juengel
* Added SpecialVision and SpecialPercept.
*
* Revision 1.16  2002/05/05 18:52:01  loetzsch
* added
* - GameControlData,
* - Receivers for GameControlData
* - access by behavior to GameControlData
*
* Revision 1.15  2002/05/04 12:43:37  loetzsch
* The currently executed MotionRequest is now sent from the MotionControl
* to the BehaviorControl via the OdometryData structure
*
* Revision 1.14  2002/05/03 15:03:29  loetzsch
* removed berlinGT2002BehaviorControl
*
* Revision 1.13  2002/04/28 19:15:14  giese
* SoundPlay added...
*
* Revision 1.12  2002/04/17 17:04:19  risler
* Darmstadt GO
*
* Revision 1.11  2002/03/28 17:45:11  loetzsch
* renamed BerlinGermanOpenBehaviorControl to XabslBehaviorControl
*
* Revision 1.10  2002/03/25 09:23:46  rentmeister
* Behavior Dialog
*
* Revision 1.9  2002/03/23 16:16:54  tim
* Moved BremenGOBehavior
*
* Revision 1.8  2002/03/21 15:18:30  koehlerj
* Add BremenGermanOpenBehaviorControl
*
* Revision 1.7  2002/03/11 12:51:00  loetzsch
* BerlinGermanOpenBehaviorControl added
*
* Revision 1.6  2002/02/12 16:06:37  fischer
* Added FuzzyBehaviorControl.
*
* Revision 1.5  2002/02/05 22:41:25  risler
* SimpleRunToBall added
*
* Revision 1.4  2002/01/20 13:00:18  risler
* changed implementation of selecting default solution
*
* Revision 1.3  2002/01/18 14:03:51  risler
* BehaviorControlSelector added
*
*/
