/** 
* @file BB2004TaskSymbols.h
*
* Declaration of class BB2004TaskSymbols.
*
* @author <a href="mailto:timlaue@informatik.uni-bremen.de">Tim Laue</a>
*/

#ifndef BB2004TaskSymbols_h_
#define BB2004TaskSymbols_h_

#include "PotentialFieldBehaviorSymbolSet.h"


/**
* @class BB2004TaskSymbols
*
* The Xabsl2 symbols that are defined in "task-symbols.xml"
*/ 
class BB2004TaskSymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
public:
  /*
  * Constructor.
  * @param interfaces The paramters of the BehaviorControl module.
  */
  BB2004TaskSymbols(const BehaviorControlInterfaces& interfaces);
  
  /** Registers the symbols at an engine 
  * @param engine A reference to the engine
  */
  void registerSymbols(Xabsl2Engine& engine);
  
  /** Updates the symbols */
  void update();

  /** The play ball behavior*/
  PotentialFieldBehaviorSymbolSet playBallSymbols;
  /** The potential field goalie behavior*/
  PotentialFieldBehaviorSymbolSet pfieldGoalieSymbols;
  /** The standard potential field defender behavior*/
  PotentialFieldBehaviorSymbolSet standardDefenderSymbols;
  /** The standard potential field supporter behavior*/
  PotentialFieldBehaviorSymbolSet standardSupporterSymbols;
};


#endif // BB2004TaskSymbols_h_


/*
* $Log: BB2004TaskSymbols.h,v $
* Revision 1.3  2004/03/25 12:05:55  tim
* added new tasks
*
* Revision 1.2  2004/03/19 15:38:01  tim
* changed BB2004BehaviorControl
*
* Revision 1.1  2004/03/15 12:37:24  tim
* BB2004 dynamic task selection classes added
*
*/

