/** 
* @file BB2004TaskSymbols.cpp
*
* Implementation of class BB2004TaskSymbols.
*
* @author <a href="mailto:timlaue@informatik.uni-bremen.de">Tim Laue</a>
*/

#include "BB2004TaskSymbols.h"
#include "Tools/FieldDimensions.h"


BB2004TaskSymbols::BB2004TaskSymbols(const BehaviorControlInterfaces& interfaces)
: BehaviorControlInterfaces(interfaces), 
  playBallSymbols(interfaces,"play-ball","Bremen/playball.pfc"),
  pfieldGoalieSymbols(interfaces,"pfield-goalie","Bremen/pfgoalie.pfc"),
  standardDefenderSymbols(interfaces,"standard-defender","Bremen/stddef.pfc"),
  standardSupporterSymbols(interfaces,"standard-supporter","Bremen/stdsupp.pfc")
{
}


void BB2004TaskSymbols::registerSymbols(Xabsl2Engine& engine)
{
  playBallSymbols.registerSymbols(engine);
  pfieldGoalieSymbols.registerSymbols(engine);
  standardDefenderSymbols.registerSymbols(engine);
  standardSupporterSymbols.registerSymbols(engine);
}


void BB2004TaskSymbols::update()
{
}


/*
* $Log: BB2004TaskSymbols.cpp,v $
* Revision 1.3  2004/03/25 12:05:55  tim
* added new tasks
*
* Revision 1.2  2004/03/19 15:38:01  tim
* changed BB2004BehaviorControl
*
* Revision 1.1  2004/03/15 12:37:24  tim
* BB2004 dynamic task selection classes added
*
*/
