/**
* @file BB2004ContinuousRules/WalkX.h
*
* @author Max Risler
*/

#ifndef __BB2004Rules_WalkX_h_
#define __BB2004Rules_WalkX_h_

#include "Tools/ContinuousBasicBehaviors/ContinuousRule.h"

namespace BB2004ContinuousRules
{

/**@class WalkX
 */
class WalkX: public ContinuousRule{
private:
  /** reference to the requested speed */
  const double &speedX;

public:
  /** constructor
   */
  WalkX(
    const BehaviorControlInterfaces& interfaces,
    const double &speedX)
    :
    ContinuousRule(interfaces,"WalkX"),
    speedX(speedX)
  {};

  /**
   * Returns whether this rule generates absolute or robot relative coordinates.
   * This rule is robot relative.
   */
  virtual bool isRelative() {return true;}

 	/** executes the basic behavior rule
   * @param robotPose the current robots pose at which the rule is to be evaluated
   * @param walk the direction and speed of the suggested motion coded as an vector (output)
	 * @param ra the rotation angle, the direction the robot should be directed (output)
	 * @param rweight the rotation weight the weight of the suggested rotation (output)
   */
  virtual void execute(const RobotPose& robotPose,
                       Vector2<double>& walk,
                       double& ra, double& rweight)
  {
    walk.x = speedX / walkMaxForwardSpeed;
    walk.y = 0;
    rweight=0;
  }
};

}

#endif //__BB2004Rules_WalkX_h_


/*
* Change log:
*
* $Log: WalkX.h,v $
* Revision 1.3  2004/03/08 00:58:49  roefer
* Interfaces should be const
*
* Revision 1.2  2003/10/31 08:32:48  dueffert
* doxygen bugs fixed
*
* Revision 1.1  2003/10/26 22:49:37  loetzsch
* created ATH2004BehaviorControl from GT2003BehaviorControl
*  - strongly simplified option graph
*  - moved some symbols from GT2003 to CommonXabsl2Symbols
*  - moved some basic behaviors from GT2003 to CommonXabsl2BasicBehaviors
*
* cloned ATH2004 three times (BB2004, DDD2004, MSH2004)
*
*/
