<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:sl="www.aiboteamhumbold.com/shootlog" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svg="http://www.w3.org/2000/svg">
	<xsl:output method="html" indent="yes"/>
	<xsl:variable name="scale" select="0.3"/>
	<xsl:variable name="width" select="750"/>
	<xsl:variable name="height" select="750"/>
	<xsl:template match="sl:shootlog">
		<html>
			<head>
				<title>ATH Shoot Log</title>
				<object id="AdobeSVG" classid="clsid:78156a80-c6a1-4bbf-8e6a-3cd390eeb4e2"/>
				<xsl:processing-instruction name="import">namespace="svg" implementation="#AdobeSVG"?</xsl:processing-instruction>
			</head>
			<body>
				<h1 id="top">ATH Shoot Log</h1>
				<p>
					<b>Description: </b>
					<xsl:value-of select="sl:description"/>
				</p>
			</body>
			<xsl:apply-templates select="sl:record" mode="index"/>
			<xsl:apply-templates select="sl:record" mode="chart"/>
			<h2>Table</h2>
			<!-- number of records -->
			<xsl:value-of select="count(sl:record)"/>
			<br/>
			<xsl:apply-templates select="sl:record" mode="table"/>
		</html>
	</xsl:template>
	<xsl:template match="sl:record" mode="index">
		<xsl:variable name="kick" select="@kick"/>
		<xsl:if test="count(preceding-sibling::sl:record[@kick=$kick])=0">
			<a>
				<xsl:attribute name="href">#<xsl:value-of select="@kick"/></xsl:attribute>
				<xsl:value-of select="@kick"/>
			</a>
			<br/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="sl:record" mode="chart">
		<xsl:variable name="kick" select="@kick"/>
		<xsl:if test="count(preceding-sibling::sl:record[@kick=$kick])=0">
			<h2 id="{@kick}">
				<xsl:value-of select="@kick"/>
			</h2>
			<p>
				<a href="#top">top</a>
			</p>
			<svg:svg id="chart{@kick}" width="{$width}" height="{$height}">
				<xsl:call-template name="draw-grid"/>
				<svg:g transform="translate({$width div 2},{$height div 2})">
					<svg:g transform="rotate(-90)">
						<xsl:for-each select="../sl:record[@kick=$kick]">
							<svg:line y1="{-1* @ballYS*$scale}" y2="{-1*@ballYA*$scale}" x1="{@ballXS*$scale}" x2="{@ballXA*$scale}" stroke="gray"/>
							<svg:circle cx="{@ballXA*$scale}" cy="{-1*@ballYA*$scale}" r="{40*$scale}" stroke="red" style="solid" fill="orange"/>
							<svg:line y1="{-1* @ballYR*$scale}" y2="{-1*@ballYS*$scale}" x1="{@ballXR*$scale}" x2="{@ballXS*$scale}" stroke="blue"/>
						</xsl:for-each>
					</svg:g>
				</svg:g>
			</svg:svg>
		</xsl:if>
	</xsl:template>
	<xsl:template name="draw-grid">
		<svg:line y1="0" y2="{$height}" x1="{$width div 2}" x2="{$width div 2}" stroke="black"/>
		<svg:line y1="{$height div 2}" y2="{$height div 2}" x1="0" x2="{$width}" stroke="black"/>
		<svg:text x="{0.47*$width}" y="{0.02*$height}" font-size="{$height div 30}" fill="black">x</svg:text>
		<svg:line x1="{$width div 2}" y1="0" x2="{0.49*$width}" y2="{0.03*$height}" stroke="black"/>
		<svg:line x1="{$width div 2}" y1="0" x2="{0.51*$width}" y2="{0.03*$height}" stroke="black"/>
		<svg:text x="{0.98*$width}" y="{0.53*$height}" font-size="{$width div 30}" fill="black">y</svg:text>
		<svg:line x1="{$width}" y1="{$height div 2}" x2="{0.97*$width}" y2="{0.49*$height}" stroke="black"/>
		<svg:line x1="{$width}" y1="{$height div 2}" x2="{0.97*$width}" y2="{0.51*$height}" stroke="black"/>
	</xsl:template>
	<xsl:template match="sl:record" mode="table">
		<xsl:value-of select="@kick"/>&#160;<xsl:value-of select="@ballXR"/>&#160;<xsl:value-of select="@ballYR"/>&#160;<xsl:value-of select="@ballTR"/>&#160;<xsl:value-of select="@ballXS"/>&#160;<xsl:value-of select="@ballYS"/>&#160;<xsl:value-of select="@ballTS"/>&#160;<xsl:value-of select="@ballXA"/>&#160;<xsl:value-of select="@ballYA"/>&#160;<xsl:value-of select="@tA"/>
		<br/>
	</xsl:template>
</xsl:stylesheet>
<!-- 
Change Log:

$Log: shootlog.xsl,v $
Revision 1.1  2004/03/16 14:00:21  juengel
Integrated Improvments from "Gnne"
-ATH2004ERS7Behavior
-ATHHeadControl
-KickSelectionTable
-KickEditor

Revision 1.2  2004/03/11 11:39:22  loetzsch
also generates a table

Revision 1.1  2004/03/06 12:52:16  loetzsch
cloned ATH2004BehaviorControl into ATH2004ERS7BehaviorControl

Revision 1.1.1.1  2004/03/05 10:10:12  loetzsch
created local cvs for Gnne

Revision 1.8  2004/03/04 18:31:18  loetzsch
collected a new log file

Revision 1.7  2004/02/04 14:09:24  loetzsch
dies & das

Revision 1.6  2004/02/03 22:42:05  loetzsch
added .spp file and the "description" element.

Revision 1.5  2004/02/03 22:24:20  loetzsch
also put width and height of the chart into a variable

Revision 1.4  2004/02/03 18:46:24  juengel
offset (x0,y0) is done with transform, translate.

Revision 1.3  2004/02/03 16:00:41  loetzsch
created new logfile

Revision 1.2  2004/01/30 14:48:04  loetzsch
improved charts

Revision 1.1  2004/01/30 13:25:28  loetzsch
using odometry data in shoot logger,
first draft of visualization

-->
