/** 
* @file ATH2004ERS7KickSelectionSymbols.h
*
* Declaration of class ATH2004ERS7KickSelectionSymbols.
*
* @author Martin Ltzsch
*/

#ifndef __ATH2004ERS7KickSelectionSymbols_h_
#define __ATH2004ERS7KickSelectionSymbols_h_

#include "../../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"
#include "Tools/KickSelectionTable.h"

/**
* The Xabsl2 symbols that are defined in "strategy-symbols.xml"
*
* @author Martin Ltzsch
*/ 
class ATH2004ERS7KickSelectionSymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
public:
  /*
  * Constructor.
  * @param interfaces The paramters of the BehaviorControl module.
  */
  ATH2004ERS7KickSelectionSymbols(BehaviorControlInterfaces& interfaces);
  
  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);

  /** A function for the function "retrieve-kick" */
  double retrieveKick();

  /** 
  * Is called for every incoming debug message.
  * @param message An interface to read the message from the queue
  * @return if the messag was read
  */
  bool handleMessage(InMessage& message);

protected:
  /** The function parameter "retrieve-kick.angle" */
  double angle;

  /** The function parameter "retrieve-kick.table-id" */
  double tableID;

  /** The kick selection table that is used */
  KickSelectionTable kickSelectionTable;
};


#endif // __ATH2004ERS7KickSelectionSymbols_h_

/*
* Change Log
* 
* $Log: ATH2004ERS7KickSelectionSymbols.h,v $
* Revision 1.3  2004/03/17 20:24:03  juengel
* handleMessage() is not virtual any more.
*
* Revision 1.2  2004/03/17 19:57:48  juengel
* handleMessage() for kickSelectionSymbols added.
*
* Revision 1.1  2004/03/16 14:00:18  juengel
* Integrated Improvments from "Gnne"
* -ATH2004ERS7Behavior
* -ATHHeadControl
* -KickSelectionTable
* -KickEditor
*
* Revision 1.3  2004/03/10 18:40:59  loetzsch
* first functioning version
*
* Revision 1.2  2004/03/09 18:48:47  loetzsch
* kick selection table changes
*
* Revision 1.1  2004/03/09 13:44:49  loetzsch
* added class ATH2004ERS7KickSelectionSymbols
*
*/

