/** 
* @file ATH2004ERS7ConfigurationSymbols.h
*
* Declaration of class ATH2004ERS7ConfigurationSymbols.
*
* @author Max Risler
*/

#ifndef __ATH2004ERS7ConfigurationSymbols_h_
#define __ATH2004ERS7ConfigurationSymbols_h_

#include "../../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"

/**
* The Xabsl2 symbols that are defined in "configuration-symbols.xml"
*
* @author Max Risler
*/ 
class ATH2004ERS7ConfigurationSymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
public:
/*
* Constructor.
* @param interfaces The parameters of the BehaviorControl module.
  */
  ATH2004ERS7ConfigurationSymbols(BehaviorControlInterfaces& interfaces);
  
  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);

  /** updates the symbols */
  void update();

  //!@name Input symbols
  //!@{
  double getCurrentKickoff(); /*!< A function for the symbol "current-kickoff-variant" */
  double getOwnKickoffX(); /*!< A function for the symbol "own-kickoff.x" */
  double getOwnKickoffY(); /*!< A function for the symbol "own-kickoff.y" */
  double getOwnKickoffAngle(); /*!< A function for the symbol "own-kickoff.angle" */
  double getOpponentKickoffX(); /*!< A function for the symbol "opponent-kickoff.x" */
  double getOpponentKickoffY(); /*!< A function for the symbol "opponent-kickoff.y" */
  double getOpponentKickoffAngle(); /*!< A function for the symbol "opponent-kickoff.angle" */
  //!@}
private:

    /** number of different kickoff variants */
  enum { numOfKickoff = 2 };

  /** the max speed with which the robot walks to its kickoff position */
  double goToKickoffMaxSpeed;

  /** the goalie start position */
  Vector2<double> goalie;

  /** the defensive supporter start position */
  Vector2<double> defensiveSupporter;

  /** the offensive supporter start position at opponent kickoff */
  Vector2<double> offensiveSupporterOpponentKickoff;
  /** the striker start position at opponent kickoff */
  Vector2<double> strikerOpponentKickoff;

  /** the offensive supporter start position at own kickoff */
  Vector2<double> offensiveSupporterOwnKickoff[numOfKickoff];
  /** the orientation of the offensive supporter at own kickoff in degrees */
  double offensiveSupporterOwnKickoffAngle[numOfKickoff];
  /** the striker start position at own kickoff */
  Vector2<double> strikerOwnKickoff[numOfKickoff];
  /** the orientation of the striker at own kickoff in degrees */
  double strikerOwnKickoffAngle[numOfKickoff];



  /**
  * current own kickoff variant 
  */
  int currentKickoff;
};


#endif // __ATH2004ERS7ConfigurationSymbols_h_

/*
* Change Log
* 
* $Log: ATH2004ERS7ConfigurationSymbols.h,v $
* Revision 1.1  2004/03/16 14:00:18  juengel
* Integrated Improvments from "Gnne"
* -ATH2004ERS7Behavior
* -ATHHeadControl
* -KickSelectionTable
* -KickEditor
*
* Revision 1.1  2004/03/06 12:52:12  loetzsch
* cloned ATH2004BehaviorControl into ATH2004ERS7BehaviorControl
*
* Revision 1.1.1.1  2004/03/05 10:10:11  loetzsch
* created local cvs for Gnne
*
* Revision 1.2  2003/10/31 08:32:47  dueffert
* doxygen bugs fixed
*
* Revision 1.1  2003/10/26 22:49:35  loetzsch
* created ATH2004ERS7BehaviorControl from GT2003BehaviorControl
*  - strongly simplified option graph
*  - moved some symbols from GT2003 to CommonXabsl2Symbols
*  - moved some basic behaviors from GT2003 to CommonXabsl2BasicBehaviors
*
* cloned ATH2004ERS7 three times (BB2004, DDD2004, MSH2004)
*
*/

