/** 
* @file ATH2004ERS7ConfigurationSymbols.cpp
*
* Implementation of class ATH2004ERS7ConfigurationSymbols.
*
* @author Max Risler
*/

#include "ATH2004ERS7ConfigurationSymbols.h"

ATH2004ERS7ConfigurationSymbols::ATH2004ERS7ConfigurationSymbols(
                           BehaviorControlInterfaces& interfaces)
: BehaviorControlInterfaces(interfaces)
{
  currentKickoff = 0;
    // start position for goalie (both kickoffs)
    goalie.x = -2000.0;
    goalie.y = 50;
    // start position for defensive supporter (both kickoffs)
    defensiveSupporter.x = -1000.0;
    defensiveSupporter.y = -200.0;

    // start position for offensive supporter (opponent kickoffs)
    offensiveSupporterOpponentKickoff.x = -1000.0;
    offensiveSupporterOpponentKickoff.y = -800.0;
    // start position for striker (opponent kickoffs)
    strikerOpponentKickoff.x = -1000.0;
    strikerOpponentKickoff.y = 500.0;

    // long kickoff to the left
    offensiveSupporterOwnKickoff[0].x = -80.0;
    offensiveSupporterOwnKickoff[0].y = 1100.0;
    offensiveSupporterOwnKickoffAngle[0] = 0.0;
    strikerOwnKickoff[0].x = -130.0;
    strikerOwnKickoff[0].y = -130.0;
    strikerOwnKickoffAngle[0] = 45.0;

    // long kickoff to the right
    offensiveSupporterOwnKickoff[1].x = -80.0;
    offensiveSupporterOwnKickoff[1].y = -1100.0;
    offensiveSupporterOwnKickoffAngle[1] = 0.0;
    strikerOwnKickoff[1].x = -130.0;
    strikerOwnKickoff[1].y = 130.0;
    strikerOwnKickoffAngle[1] = -45.0;

}

void ATH2004ERS7ConfigurationSymbols::registerSymbols(Xabsl2Engine& engine)
{
  engine.registerDecimalInputSymbol("current-kickoff-variant",this,
    (double (Xabsl2FunctionProvider::*)())&ATH2004ERS7ConfigurationSymbols::getCurrentKickoff);

  engine.registerDecimalInputSymbol("own-kickoff.angle",this,
    (double (Xabsl2FunctionProvider::*)())&ATH2004ERS7ConfigurationSymbols::getOwnKickoffAngle);
  engine.registerDecimalInputSymbol("own-kickoff.x",this,
    (double (Xabsl2FunctionProvider::*)())&ATH2004ERS7ConfigurationSymbols::getOwnKickoffX);
  engine.registerDecimalInputSymbol("own-kickoff.y",this,
    (double (Xabsl2FunctionProvider::*)())&ATH2004ERS7ConfigurationSymbols::getOwnKickoffY);

  engine.registerDecimalInputSymbol("opponent-kickoff.angle",this,
    (double (Xabsl2FunctionProvider::*)())&ATH2004ERS7ConfigurationSymbols::getOpponentKickoffAngle);
  engine.registerDecimalInputSymbol("opponent-kickoff.x",this,
    (double (Xabsl2FunctionProvider::*)())&ATH2004ERS7ConfigurationSymbols::getOpponentKickoffX);
  engine.registerDecimalInputSymbol("opponent-kickoff.y",this,
    (double (Xabsl2FunctionProvider::*)())&ATH2004ERS7ConfigurationSymbols::getOpponentKickoffY);
}

void ATH2004ERS7ConfigurationSymbols::update()
{
  currentKickoff = gameControlData.data.opponentScore % numOfKickoff;
}

double ATH2004ERS7ConfigurationSymbols::getCurrentKickoff()
{
  return currentKickoff;
}

double ATH2004ERS7ConfigurationSymbols::getOwnKickoffAngle()
{
  switch (getPlayer().getPlayerNumber())
  {
    case Player::one: // robot number 1
    case Player::two: // robot number 2
    default:
      return 0;
    case Player::three: // robot number 3
      return offensiveSupporterOwnKickoffAngle[currentKickoff];
    case Player::four: // robot number 4
      return strikerOwnKickoffAngle[currentKickoff];
  }
}

double ATH2004ERS7ConfigurationSymbols::getOwnKickoffX()
{
  switch (getPlayer().getPlayerNumber())
  {
    case Player::one: // robot number 1
    default:
      return goalie.x;
    case Player::two: // robot number 2
      return defensiveSupporter.x;
    case Player::three: // robot number 3
      return offensiveSupporterOwnKickoff[currentKickoff].x;
    case Player::four: // robot number 4
      return strikerOwnKickoff[currentKickoff].x;
  }
}

double ATH2004ERS7ConfigurationSymbols::getOwnKickoffY()
{
  switch (getPlayer().getPlayerNumber())
  {
    case Player::one: // robot number 1
    default:
      return goalie.y;
    case Player::two: // robot number 2
      return defensiveSupporter.y;
    case Player::three: // robot number 3
      return offensiveSupporterOwnKickoff[currentKickoff].y;
    case Player::four: // robot number 4
      return strikerOwnKickoff[currentKickoff].y;
  }
}

double ATH2004ERS7ConfigurationSymbols::getOpponentKickoffAngle()
{
  switch (getPlayer().getPlayerNumber())
  {
    case Player::one: // robot number 1
    case Player::two: // robot number 2
    case Player::three: // robot number 3
    case Player::four: // robot number 4
    default:
      return 0;
  }
}

double ATH2004ERS7ConfigurationSymbols::getOpponentKickoffX()
{
  switch (getPlayer().getPlayerNumber())
  {
    case Player::one: // robot number 1
    default:
      return goalie.x;
    case Player::two: // robot number 2
      return defensiveSupporter.x;
    case Player::three: // robot number 3
      return offensiveSupporterOpponentKickoff.x;
    case Player::four: // robot number 4
      return strikerOpponentKickoff.x;
  }
}

double ATH2004ERS7ConfigurationSymbols::getOpponentKickoffY()
{
  switch (getPlayer().getPlayerNumber())
  {
    case Player::one: // robot number 1
    default:
      return goalie.y;
    case Player::two: // robot number 2
      return defensiveSupporter.y;
    case Player::three: // robot number 3
      return offensiveSupporterOpponentKickoff.y;
    case Player::four: // robot number 4
      return strikerOpponentKickoff.y;
  }
}

/*
* Change Log
* 
* $Log: ATH2004ERS7ConfigurationSymbols.cpp,v $
* Revision 1.1  2004/03/16 14:00:18  juengel
* Integrated Improvments from "Gnne"
* -ATH2004ERS7Behavior
* -ATHHeadControl
* -KickSelectionTable
* -KickEditor
*
* Revision 1.1  2004/03/06 12:52:12  loetzsch
* cloned ATH2004BehaviorControl into ATH2004ERS7BehaviorControl
*
* Revision 1.1.1.1  2004/03/05 10:10:11  loetzsch
* created local cvs for Gnne
*
* Revision 1.2  2003/12/06 17:45:33  loetzsch
* replaced Player::playerRole (goalie, defender, striker1, striker2)
* by Player::playerNumber (one, two, three, four)
*
* Revision 1.1  2003/10/26 22:49:35  loetzsch
* created ATH2004ERS7BehaviorControl from GT2003BehaviorControl
*  - strongly simplified option graph
*  - moved some symbols from GT2003 to CommonXabsl2Symbols
*  - moved some basic behaviors from GT2003 to CommonXabsl2BasicBehaviors
*
* cloned ATH2004ERS7 three times (BB2004, DDD2004, MSH2004)
*
*/

