/** 
* @file ATH2004StrategySymbols.h
*
* Declaration of class ATH2004StrategySymbols.
*
* @author Martin Ltzsch
*/

#ifndef __ATH2004StrategySymbols_h_
#define __ATH2004StrategySymbols_h_

#include "../../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"
#include "Tools/Streams/InStreams.h"
#include "Tools/Streams/OutStreams.h"

/**
* The Xabsl2 symbols that are defined in "strategy-symbols.xml"
*
* @author Martin Ltzsch
*/ 
class ATH2004StrategySymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
public:
  /*
  * Constructor.
  * @param interfaces The paramters of the BehaviorControl module.
  */
  ATH2004StrategySymbols(const BehaviorControlInterfaces& interfaces);
  
  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);
  
  /** updates the symbols */
  void update();

  /** current estimated time to reach the ball */
  double estimatedTimeToReachBall;

  /** computes the estimated time to reach the ball */
  void estimateTimeToReachBall();

  /** current role */
  BehaviorTeamMessage::DynamicRole role;

  /** computes the current role */
  void computeRole();

  //!@name Input symbols
  //!@{
  /* 
  * A function for the symbol "robot-number". 
  * Returns the robots back number as read from player.cfg 
  */
  double getRobotNumber() { return (double)(getPlayer().getPlayerNumber() + 1); };

  /*!< calculates the value for the input function get-angle-to-teammate with parameter index */
  double getAngleToTeammate();  
  /*!< the Parameter "robot-pose.get-angle-to-teammate.index" for the decimal input function "robot-pose.get-angle-to-teammate" */
  double angleToTeammateIndex; 

  /** A function for the symbol "another-player-is-in-ready-state". */
  bool getAnotherPlayerIsInReadyState();

  /** A function for the symbol "another-teammate-is-preparing-a-kick" */
  bool getAnotherTeammateIsPreparingAKick();

  /** A function for the symbol "another-teammate-is-performing-a-kick" */
  bool getAnotherTeammateIsPerformingAKick();

  /** A function for the symbol "another-teammate-just-performed-a-kick" */
  bool getAnotherTeammateJustPerformedAKick();

  /** A function for the symbol "the-striker-is-playing-near-the-opponent-goal" */
  bool getTheStrikerIsPlayingNearTheOpponentGoal();

  /** A function for the symbol "the-striker-is-not-playing-near-the-opponent-goal" */
  bool getTheStrikerIsNotPlayingNearTheOpponentGoal();

  /** A function for the symbol "the-striker-is-playing-near-the-own-goal" */
  bool getTheStrikerIsPlayingNearTheOwnGoal();

  /** A function for the symbol "the-striker-is-not-playing-near-the-own-goal" */
  bool getTheStrikerIsNotPlayingNearTheOwnGoal();

  /** A funtion for the symbol "catch-ball" */
  bool getCaught(); 

  /** A function for the symbol "catch-ball-time" */
  double getCatchTime(); 

  /** A function for the symbol "search-ball.x" */
  double getSearchBallX();

  /** A function for the symbol "get-good-x" */

  double getGoodX();

  /** A function for the symbol "get-good-y" */

  double getGoodY();

  /** A function for the function "get-good-shot" */
  double getGoodShot();

  /** Parameter for the function "get-good-shot" */
  double getGoodShotAngle;

  /** The last calculated good shot.*/
  double goodShot;
  //!@}

  /** Shot we use next time */
  int nextShot;

  /** The time when the ball was started to catch */
  unsigned long timeWhenBallWasStartedToCatch;

  /** The time until the ball was caught */
  unsigned long timeUntilBallWasCaught;

  /** Indicates if the robot is stuck (based on obstacles model)*/
  bool robotIsStuck;

  /** Indicates that there are close obstacles */
  bool obstaclesAreClose;

   /** Goalie,go to ball ? (Yes or No) , set Symbol useShoot*/
  bool goalieGoToBall();

  enum goalieClearBallBehaviorType { ACTIVE,PASSIVE };

  goalieClearBallBehaviorType goalieClearBallBehavior;

private:
	/** Goalie go to ball and use last decision */
	bool getDecisionGoalieGoToBall(bool lastDecision);
};


#endif // __ATH2004StrategySymbols_h_

/*
* Change Log
* 
* $Log: ATH2004StrategySymbols.h,v $
* Revision 1.15  2004/04/08 10:08:41  risler
* fixed and unified team color symbols
*
* Revision 1.14  2004/03/16 18:37:24  brueckne
* Added ATH2004StrategySymbols::getGoodX/Y
*
* Revision 1.13  2004/03/08 00:58:44  roefer
* Interfaces should be const
*
* Revision 1.12  2004/03/04 17:25:23  sombrutz
* added symbol goalie-clear-ball-behavior
*
* Revision 1.11  2004/03/04 15:09:09  sombrutz
* added getDecisionGoalieGoToBall(bool lastDecision) (private)
*
* Revision 1.10  2004/02/27 15:29:06  juengel
* Added getTeamColor().
*
* Revision 1.9  2004/02/27 10:43:28  spranger
* added get-Angle-to-Teammate function and parameter
*
* Revision 1.8  2004/02/26 17:17:29  loetzsch
* bug fixes and renaming of "shoot" to "shot"
*
* Revision 1.7  2004/02/26 14:41:47  brueckne
* Continued penality shooter hertha
*
* Revision 1.6  2004/02/13 11:30:42  sombrutz
* add GoalieGoToBall ( used by the new goalie)
*
* Revision 1.5  2004/01/22 12:43:13  dueffert
* flush removed because it doesnt work properly on robots
*
* Revision 1.4  2004/01/13 18:06:31  brueckne
* One step closer to getGoodShoot
*
* Revision 1.3  2003/12/11 17:08:17  brueckne
* Continued penalty-shooter-hertha
*
* Revision 1.2  2003/12/06 17:45:33  loetzsch
* replaced Player::playerRole (goalie, defender, striker1, striker2)
* by Player::playerNumber (one, two, three, four)
*
* Revision 1.1  2003/10/26 22:49:35  loetzsch
* created ATH2004BehaviorControl from GT2003BehaviorControl
*  - strongly simplified option graph
*  - moved some symbols from GT2003 to CommonXabsl2Symbols
*  - moved some basic behaviors from GT2003 to CommonXabsl2BasicBehaviors
*
* cloned ATH2004 three times (BB2004, DDD2004, MSH2004)
*
*/

