/** 
* @file ATH2004ConfigurationSymbols.cpp
*
* Implementation of class ATH2004ConfigurationSymbols.
*
* @author Max Risler
*/

#include "ATH2004ConfigurationSymbols.h"

ATH2004ConfigurationSymbols::ATH2004ConfigurationSymbols(
                           const BehaviorControlInterfaces& interfaces,
                           ATH2004BehaviorConfiguration& configuration)
: BehaviorControlInterfaces(interfaces),
  configuration(configuration)
{
  currentKickoff = 0;
}

void ATH2004ConfigurationSymbols::registerSymbols(Xabsl2Engine& engine)
{
  engine.registerDecimalInputSymbol("current-kickoff-variant",this,
    (double (Xabsl2FunctionProvider::*)())&ATH2004ConfigurationSymbols::getCurrentKickoff);

  engine.registerDecimalInputSymbol("go-to-kickoff-position.max-speed",&(configuration.goToKickoffMaxSpeed));

  engine.registerDecimalInputSymbol("own-kickoff.angle",this,
    (double (Xabsl2FunctionProvider::*)())&ATH2004ConfigurationSymbols::getOwnKickoffAngle);
  engine.registerDecimalInputSymbol("own-kickoff.x",this,
    (double (Xabsl2FunctionProvider::*)())&ATH2004ConfigurationSymbols::getOwnKickoffX);
  engine.registerDecimalInputSymbol("own-kickoff.y",this,
    (double (Xabsl2FunctionProvider::*)())&ATH2004ConfigurationSymbols::getOwnKickoffY);

  engine.registerDecimalInputSymbol("opponent-kickoff.angle",this,
    (double (Xabsl2FunctionProvider::*)())&ATH2004ConfigurationSymbols::getOpponentKickoffAngle);
  engine.registerDecimalInputSymbol("opponent-kickoff.x",this,
    (double (Xabsl2FunctionProvider::*)())&ATH2004ConfigurationSymbols::getOpponentKickoffX);
  engine.registerDecimalInputSymbol("opponent-kickoff.y",this,
    (double (Xabsl2FunctionProvider::*)())&ATH2004ConfigurationSymbols::getOpponentKickoffY);

  engine.registerDecimalInputSymbol("ball-near-distance",&(configuration.ballNearDistance));
  engine.registerDecimalInputSymbol("ball-not-near-distance",&(configuration.ballNotNearDistance));
  engine.registerDecimalInputSymbol("at-ball-distance",&(configuration.atBallDistance));
  engine.registerDecimalInputSymbol("not-at-ball-distance",&(configuration.notAtBallDistance));

  // "dribble.speed-y"
  engine.registerDecimalInputSymbol("dribble.speed-y",this,
    (double (Xabsl2FunctionProvider::*)())&ATH2004ConfigurationSymbols::getDribbleSpeedY);
}

void ATH2004ConfigurationSymbols::update()
{
  currentKickoff = gameControlData.data.opponentScore % ATH2004BehaviorConfiguration::numOfKickoff;
}

double ATH2004ConfigurationSymbols::getCurrentKickoff()
{
  return currentKickoff;
}

double ATH2004ConfigurationSymbols::getOwnKickoffAngle()
{
  switch (getPlayer().getPlayerNumber())
  {
    case Player::one: // robot number 1
    case Player::two: // robot number 2
    default:
      return 0;
    case Player::three: // robot number 3
      return configuration.offensiveSupporterOwnKickoffAngle[currentKickoff];
    case Player::four: // robot number 4
      return configuration.strikerOwnKickoffAngle[currentKickoff];
  }
}

double ATH2004ConfigurationSymbols::getOwnKickoffX()
{
  switch (getPlayer().getPlayerNumber())
  {
    case Player::one: // robot number 1
    default:
      return configuration.goalie.x;
    case Player::two: // robot number 2
      return configuration.defensiveSupporter.x;
    case Player::three: // robot number 3
      return configuration.offensiveSupporterOwnKickoff[currentKickoff].x;
    case Player::four: // robot number 4
      return configuration.strikerOwnKickoff[currentKickoff].x;
  }
}

double ATH2004ConfigurationSymbols::getOwnKickoffY()
{
  switch (getPlayer().getPlayerNumber())
  {
    case Player::one: // robot number 1
    default:
      return configuration.goalie.y;
    case Player::two: // robot number 2
      return configuration.defensiveSupporter.y;
    case Player::three: // robot number 3
      return configuration.offensiveSupporterOwnKickoff[currentKickoff].y;
    case Player::four: // robot number 4
      return configuration.strikerOwnKickoff[currentKickoff].y;
  }
}

double ATH2004ConfigurationSymbols::getOpponentKickoffAngle()
{
  switch (getPlayer().getPlayerNumber())
  {
    case Player::one: // robot number 1
    case Player::two: // robot number 2
    case Player::three: // robot number 3
    case Player::four: // robot number 4
    default:
      return 0;
  }
}

double ATH2004ConfigurationSymbols::getOpponentKickoffX()
{
  switch (getPlayer().getPlayerNumber())
  {
    case Player::one: // robot number 1
    default:
      return configuration.goalie.x;
    case Player::two: // robot number 2
      return configuration.defensiveSupporter.x;
    case Player::three: // robot number 3
      return configuration.offensiveSupporterOpponentKickoff.x;
    case Player::four: // robot number 4
      return configuration.strikerOpponentKickoff.x;
  }
}

double ATH2004ConfigurationSymbols::getOpponentKickoffY()
{
  switch (getPlayer().getPlayerNumber())
  {
    case Player::one: // robot number 1
    default:
      return configuration.goalie.y;
    case Player::two: // robot number 2
      return configuration.defensiveSupporter.y;
    case Player::three: // robot number 3
      return configuration.offensiveSupporterOpponentKickoff.y;
    case Player::four: // robot number 4
      return configuration.strikerOpponentKickoff.y;
  }
}

double ATH2004ConfigurationSymbols::getDribbleSpeedY()
{
  double distanceY = Geometry::distanceTo(robotPose.getPose(),ballPosition.seen) * 
    sin(Geometry::angleTo(robotPose.getPose(),ballPosition.seen));

  if (distanceY < -175)
    return -200;
  else if (distanceY < 0)
    return (150 + 2 * distanceY); 
  else if (distanceY < 175)
    return (-150 + 2 * distanceY);
  else return 200;
}


/*
* Change Log
* 
* $Log: ATH2004ConfigurationSymbols.cpp,v $
* Revision 1.3  2004/03/08 00:58:44  roefer
* Interfaces should be const
*
* Revision 1.2  2003/12/06 17:45:33  loetzsch
* replaced Player::playerRole (goalie, defender, striker1, striker2)
* by Player::playerNumber (one, two, three, four)
*
* Revision 1.1  2003/10/26 22:49:35  loetzsch
* created ATH2004BehaviorControl from GT2003BehaviorControl
*  - strongly simplified option graph
*  - moved some symbols from GT2003 to CommonXabsl2Symbols
*  - moved some basic behaviors from GT2003 to CommonXabsl2BasicBehaviors
*
* cloned ATH2004 three times (BB2004, DDD2004, MSH2004)
*
*/

