/**
 * @file BB2004BallLocator.h
 * 
 * This file contains default class for ball-localization.
 *
 * @author <a href="mailto:jhoffman@informatik.hu-berlin.de">Jan Hoffmann</a>
 */

#ifndef __BB2004BallLocator_h_
#define __BB2004BallLocator_h_

#include "BallLocator.h"
#include "Tools/Debugging/GenericDebugData.h"
#include "Tools/Math/PIDsmoothedValue.h"
#include "BallSideDetector.h"

/**
* @class BB2004BallLocator
*
* A solution of the BallLocator module.
*
*
 * @author <a href="mailto:jhoffman@informatik.hu-berlin.de">Jan Hoffmann</a>
*/
class BB2004BallLocator : public BallLocator
{
public:
  /** 
  * Constructor.
  * @param interfaces The paramters of the BallLocator module.
  */
  BB2004BallLocator(const BallLocatorInterfaces& interfaces);

  /** Executes the module */
  virtual void execute();

private:
    Pose2D corner[10]; /**< The body corners. */
    double length[10]; /**< The lengths of the border segments starting at a corresponding corner. */
    PIDsmoothedValue ballPosX, ballPosY, ballSpeedX, ballSpeedY;
		PIDsmoothedValue ballAngle, ballDistance; 
    Vector2<double> lastBallSeen;
    Pose2D lastBallPercept,
           lastRobotOdometry; 
    long consecutiveFramesBallSeen;
    long consecutiveFramesBallNotSeen;
    unsigned long lastTimeBallSeen;
    unsigned long lastTimeBallReallySeen;

    Vector2<double> relative2FieldCoord(RobotPose rp, double x, double y);
    void compensateOdometry();

    bool handleMessage(InMessage& message);

    bool bodyClip(Vector2<double>& offset) const;
    bool inside(int start, Vector2<double>& offset) const;

    /** used for detecting whether the ball is fast and close */
    BallSideDetector ballSideDetector;
  
};

#endif// __BB2004BallLocator_h_

/*
 * Change log :
 * $Log: BB2004BallLocator.h,v $
 * Revision 1.1  2004/04/09 11:35:51  roefer
 * Bremen Byters German Open check-in
 *
 * Revision 1.3  2004/04/02 21:38:59  roefer
 * Two quadrangles for bodyClip, lastTimeBallReallySeen added
 *
 * Revision 1.2  2004/03/30 21:31:22  roefer
 * Better head control and ball modelling
 *
 * Revision 1.1  2004/03/29 15:44:35  fritsche
 * BallLocator for Tim
 *
 * Revision 1.3  2004/03/08 00:58:37  roefer
 * Interfaces should be const
 *
 * Revision 1.2  2004/01/13 18:35:24  heinze
 * added ball-side-detector
 *
 * Revision 1.1  2003/10/06 13:33:15  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/09/26 11:38:51  juengel
 * - sorted tools
 * - clean-up in DataTypes
 *
 * Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.12  2003/06/20 16:37:51  jhoffman
 * smoothing lessened
 *
 * Revision 1.11  2003/06/03 08:57:12  roefer
 * Modelling of speed for unseen ball improved
 *
 * Revision 1.10  2003/05/01 17:09:06  loetzsch
 * Redesign of ball modeling:
 * - Modularized class BallPosition
 * - splitted up module "BallLocator" into "BallLocator" for modeling of percepts
 *   and "TeamBallLocator" for modelling communicated positions
 * - Removed solution JumpingBallLocator
 * - Splitted Solution DefaultBallLocator into DefaultBallLocator and DefaultTeamBallLocator
 * - Renamed SensorFusionBallLocator to GaussBellTeamBallLocator
 *
 * Revision 1.9  2003/04/03 21:08:19  jhoffman
 * variable renamed
 *
 * Revision 1.8  2003/04/02 11:01:53  jhoffman
 * added odometry correction
 *
 * Revision 1.7  2003/04/02 08:56:48  jhoffman
 * ball locator stores and smoothes relative ball positions and adds robot pose
 * each frame to generate the position on the field
 *
 * Revision 1.6  2003/03/25 17:07:20  dueffert
 * warning removed
 *
 * Revision 1.5  2003/03/19 15:37:47  jhoffman
 * now calculates proper speed
 *
 * Revision 1.4  2003/03/05 14:59:15  jhoffman
 * log added
 * 
 *
 */
