//#include <string>
//#include <stdio>
//#include <iostream>

#include "Platform/File.h"
#include <wtypes.h>

#define MAXBIN 6
#define MAXCPP 600
#define MAXH 1000
#define MAXPATH 256
#define MAXDEFS 4000
#define MAXDEFLEN 128
#define MAXINCDIR 32
#define MAXFILESIZE 250000
#define BUFSIZE 15728640

int numberOfDefs;
char defList[MAXDEFS][MAXDEFLEN];
int numberOfSysDefs;
char sysDefList[MAXDEFS][MAXDEFLEN];

int numberOfIncDirs;
char incDirList[MAXINCDIR][MAXPATH];
char buildDir[MAXPATH];
char processSet[MAXPATH];
char projectName[MAXPATH];

int numberOfBins;
int currentBin;
char binList[MAXBIN][MAXPATH];
char binNameList[MAXBIN][MAXDEFLEN];

int numberOfCpps;
int currentCpp;
char cppList[MAXCPP][MAXPATH];

int numberOfOdeps[MAXCPP];
int currentOdep;
char* odepList[MAXCPP][MAXH];


int numberOfBindeps[MAXBIN];
char* bindepList[MAXBIN][MAXCPP];

bool generateDsp;
bool generateVcproj;
bool weAreInsideIf;
char* currentFile;
int* currentLine;
char errText[1024];


int numberOfFiles;
char* fileList[MAXCPP+MAXH];
char* fileStart[MAXCPP+MAXH];
char buffer[BUFSIZE];
char* currentBuf;
void addSourceFile(const char* s);
void addSourceDir(const char* s);
void sortFileList(int von, int bis);
char* getFileStart(const char* s);

void errExit();
void getPath(char* path, const char* file);
void define(const char* s);
void undef(const char* s);
bool ifdef(const char* s);
bool ifndef(const char* s);
void skipSpaces(char** p);
void skipCurrentLine(char** p);
void parseIf(char** p);
void parseIfdef(char** p);
void parseIfndef(char** p);
void parseInclude(char** p);
void parseDefine(char** p);
void parseUndef(char** p);
void skipComment(char** p);
void parseFile(char* s);
void parseBins();
void generateOdeps(FILE* f);
void generateBindeps(FILE* f);
void addDep(const char* s);
void addCpp(const char* s);
void addBin(const char* cpp, const char* binname);
void usage();

class dspNode
{
public:
  dspNode(char* apath,char* aname=0):dirList(0),filList(0),next(0),name(0)
  {
    path=strdup(apath);
    if (aname)
    {
      name=strdup(aname);
    }
  }

  ~dspNode()
  {
    delete(path);
    if (name)
    {
      delete(name);
    }
    if (next)
    {
      delete(next);
    }
    if (filList)
    {
      delete(filList);
    }
    if (dirList)
    {
      delete(dirList);
    }
  }

  void add (char* relpath)
  {
    char* afterDir=strchr(relpath,'/');
    if (afterDir)
    {
      //create new dir node and/or insert file into dirlist
      char dirname[MAXPATH];
      char dirpath[MAXPATH];
      dirname[afterDir-relpath]=0;
      strncpy(dirname,relpath,afterDir-relpath);
      sprintf(dirpath,"%s/%s",path,dirname);
      //2do: while dirname in list strcat(dirname,"_"), add to list: to avoid RobotControl Nr. 1;
      dspNode** subdirp=&dirList;
      if (*subdirp)
      {
        while(*subdirp)
        {
          if (strcmp((*subdirp)->path,dirpath)==0)
          {
            break;
          }
          else if (strcmp((*subdirp)->path,dirpath)>0)
          {
            dspNode* neu=new dspNode(dirpath,dirname);
            neu->next=*subdirp;
            *subdirp=neu;
            break;
          }
          subdirp=&((*subdirp)->next);
        }
      }
      if (*subdirp==0)
      {
        (*subdirp)=new dspNode(dirpath,dirname);
      }
      (*subdirp)->add(afterDir+1);
    }
    else
    {
      //there is no / in relpath any more
      if (name)
      {
        //we are in a directory, so add file to or before filList
        if (filList)
        {
          if (strcmp(relpath,filList->path)<0)
          {
            dspNode* neu=new dspNode(relpath);
            neu->next=filList;
            filList=neu;
          }
          else if (strcmp(relpath,filList->path)>0)
          {
            filList->add(relpath);
          }
        }
        else
        {
          filList=new dspNode(relpath);
        }
      }
      else
      {
        //we are in a file, so add it to or before next
        if (next)
        {
          if (strcmp(relpath,next->path)<0)
          {
            dspNode* neu=new dspNode(relpath);
            neu->next=next;
            next=neu;
          }
          else if (strcmp(relpath,next->path)>0)
          {
            next->add(relpath);
          }
        }
        else
        {
          next=new dspNode(relpath);
        }
      }
    }
  }

  void dsprintf(FILE* f)
  {
    dspNode* dir=dirList;
    if (dir)
    {
      while(dir)
      {
        fprintf(f,"# Begin Group \"%s\"\r\n\r\n# PROP Default_Filter \"\"\r\n",dir->name);
        dir->dsprintf(f);
        fprintf(f,"# End Group\r\n");
        dir=dir->next;
      }
    }
    dspNode* fil=filList;
    while(fil)
    {
      char src[MAXPATH];
      sprintf(src,"# Begin Source File\r\n\r\nSOURCE=%s/%s\r\n# End Source File\r\n",path,fil->path);
      char* convert=src;
      while(*convert)
      {
        if ((*convert)=='/')
        {
          *convert ='\\';
        }
        convert++;
      }
      fprintf(f,src);
      fil=fil->next;
    }
  }

  void vcprintf(FILE* f, int level)
  {
    int i;
	size_t len;
    char buf[1024];
    dspNode* dir=dirList;
    if (dir)
    {
      while(dir)
      {
        if(strcmp(projectName, "_Simulator") || (strcmp(dir->name, "Platform") && strcmp(dir->name, "SimRobXP") && strcmp(dir->name, "RobotControl")))
        {
          len=0;
          for (i=0;i<level;i++) { buf[len+1]=0; buf[len]='\t'; len++; }
          sprintf(&buf[len],"<Filter\r\n");
          len=strlen(buf);
          for (i=0;i<level;i++) { buf[len+1]=0; buf[len]='\t'; len++; }
          sprintf(&buf[len],"\tName=\"%s\"\r\n",dir->name);
          len=strlen(buf);
          for (i=0;i<level;i++) { buf[len+1]=0; buf[len]='\t'; len++; }
          strcat(buf,"\tFilter=\"\">\r\n");
          fprintf(f,buf);

          dir->vcprintf(f,level+1);

          len=0;
          for (i=0;i<level;i++) { buf[len+1]=0; buf[len]='\t'; len++; }
          sprintf(&buf[len],"</Filter>\r\n");
          fprintf(f,buf);
        }
        dir=dir->next;
      }
    }
    dspNode* fil=filList;
    while(fil)
    {
      len=0;
      for (i=0;i<level;i++) { buf[len+1]=0; buf[len]='\t'; len++; }
      sprintf(&buf[len],"<File\r\n");
      len=strlen(buf);
      for (i=0;i<level;i++) { buf[len+1]=0; buf[len]='\t'; len++; }
      sprintf(&buf[len],"\tRelativePath=\"%s/%s\">\r\n",path,fil->path);
      char* convert=buf;
      while(*convert)
      {
        if ((*convert)=='/')
        {
          *convert ='\\';
        }
        convert++;
      }
      if ((strcmp(&fil->path[strlen(fil->path)-4],".cpp")==0)&&(projectName[0]!=0))
      {
        //cpp-block adden
        len=strlen(buf);
        for (i=0;i<level;i++) { buf[len+1]=0; buf[len]='\t'; len++; }
        sprintf(&buf[len],"\t<FileConfiguration\r\n");
        len=strlen(buf);
        for (i=0;i<level;i++) { buf[len+1]=0; buf[len]='\t'; len++; }
        sprintf(&buf[len],"\t\tName=\"%s %s Debug|Win32\">\r\n",projectName,processSet);
        len=strlen(buf);
        for (i=0;i<level;i++) { buf[len+1]=0; buf[len]='\t'; len++; }
        sprintf(&buf[len],"\t\t<Tool\r\n");
        len=strlen(buf);
        for (i=0;i<level;i++) { buf[len+1]=0; buf[len]='\t'; len++; }
        sprintf(&buf[len],"\t\t\tName=\"VCCLCompilerTool\"\r\n");
        len=strlen(buf);
        for (i=0;i<level;i++) { buf[len+1]=0; buf[len]='\t'; len++; }
        sprintf(&buf[len],"\t\t\tOptimization=\"0\"\r\n");
        len=strlen(buf);
        for (i=0;i<level;i++) { buf[len+1]=0; buf[len]='\t'; len++; }
        sprintf(&buf[len],"\t\t\tAdditionalIncludeDirectories=\"\"\r\n");
        len=strlen(buf);
        for (i=0;i<level;i++) { buf[len+1]=0; buf[len]='\t'; len++; }
        sprintf(&buf[len],"\t\t\tPreprocessorDefinitions=\"\"");
        if (strcmp(projectName,"RobotControl")==0)
        {
          strcat(buf,"\r\n");
          len=strlen(buf);
          for (i=0;i<level;i++) { buf[len+1]=0; buf[len]='\t'; len++; }
          sprintf(&buf[len],"\t\t\tBasicRuntimeChecks=\"3\"\r\n");
          len=strlen(buf);
          for (i=0;i<level;i++) { buf[len+1]=0; buf[len]='\t'; len++; }
          sprintf(&buf[len],"\t\t\tBrowseInformation=\"1\"/>\r\n");
        }
        else
        {
          strcat(buf,"/>\r\n");
        }
        len=strlen(buf);
        for (i=0;i<level;i++) { buf[len+1]=0; buf[len]='\t'; len++; }
        sprintf(&buf[len],"\t</FileConfiguration>\r\n");
      }
      len=strlen(buf);
      for (i=0;i<level;i++) { buf[len+1]=0; buf[len]='\t'; len++; }
      sprintf(&buf[len],"</File>\r\n");
      fprintf(f,buf);
      fil=fil->next;
    }
  }
private:
  //dir only:
  char* name;
  dspNode* dirList;
  dspNode* filList;
  //file and dir:
  char* path;
  dspNode* next;
};

void sortFileList(int von, int bis)
{
  int v=von;
  int b=bis;
  char* m=fileList[(v+b)/2];
  do
  {
    //2do: the list of files shall be sorted case insensitive for VS, but for that we have to
    //     change searching in the tree, because we do everything else case sensitive
    //while (stricmp(fileList[v],m)<0) v++;
    //while (stricmp(m,fileList[b])<0) b--;
    while (strcmp(fileList[v],m)<0) v++;
    while (strcmp(m,fileList[b])<0) b--;
    if (v<b)
    {
      char* name=fileList[v];
      char* start=fileStart[v];
      fileList[v]=fileList[b];
      fileStart[v]=fileStart[b];
      fileList[b]=name;
      fileStart[b]=start;
      //v++; b--; //klappt nicht bei Gleichheit mit Grenze!!!
    }
  } while (v<b);

  if (v==b) //wenn Mitte stimmt, nicht mitsortieren
  {
    if (v<bis) v++;
    if (von<b) b--;
  }
  if (von<b) sortFileList(von,b);
  if (v<bis) sortFileList(v,bis);
}

void addSourceFile(const char* s)
{
  FILE* f=fopen(s,"rb");
  if (f>0)
  {
    fileList[numberOfFiles]=strdup(s);
    fileStart[numberOfFiles++]=currentBuf;
    if (currentBuf-buffer >= BUFSIZE-MAXFILESIZE)
    {
      sprintf(errText,"increase BUFSIZE in Depend.cpp, the length of all source files exceeds %i",BUFSIZE); errExit();
    }
    size_t x=fread(currentBuf,1,MAXFILESIZE,f);
    fclose(f);
    if (x==MAXFILESIZE)
    {
      sprintf(errText,"increase MAXFILESIZE in Depend.cpp: this file is larger than %i",MAXFILESIZE); errExit();
    }
    currentBuf += x;
    *currentBuf = 0;
    currentBuf++;
  }
}

void addSourceDir(const char* s)
{
  WIN32_FIND_DATA ff;
  char ffname[MAXPATH];
  sprintf(ffname,"%s/*",s);
  HANDLE hFile = FindFirstFile(ffname,&ff);
  bool thereAreMore = (hFile != INVALID_HANDLE_VALUE);
  while (thereAreMore)
  {
    if (((ff.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY )== 0)&&
      (((strlen(ff.cFileName)>4)&&(stricmp(ff.cFileName+strlen(ff.cFileName)-4,".cpp")==0))||
      ((strlen(ff.cFileName)>2)&&(stricmp(ff.cFileName+strlen(ff.cFileName)-2,".h")==0))))
    {
      sprintf(ffname,"%s/%s",s,ff.cFileName);
      addSourceFile(ffname);
    }
    else if (((ff.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY )!= 0)&&(strcmp(ff.cFileName,".")!=0)&&(strcmp(ff.cFileName,"..")!=0)&&(strcmp(ff.cFileName,"CVS")!=0))
    {
      sprintf(ffname,"%s/%s",s,ff.cFileName);
      addSourceDir(ffname);
    }
    thereAreMore=(FindNextFile(hFile,&ff)!=0);
  }
  FindClose(hFile);
}

char* getFileStart(const char* s)
{
  int min=0;
  int max=numberOfFiles-1;
  while (1)
  {
    int i=(max+min)/2;
    switch (strcmp(fileList[i],s))
    {
    case 0:
      return fileStart[i];
    case 1:
      if (max<=min) return 0;
      max=i-1;
      break;
    case -1:
      if (max<=min) return 0;
      min=i+1;
    }
  }
}

void errExit()
{
  printf("%s(%i): error : %s\n",currentFile,*currentLine,errText);
  exit(1);
}

void getPath(char* path, const char* file)
{
  char s[MAXPATH];
  char t[MAXPATH];
  char* sf;
  if (strchr(file,':')>file)
  {
    if (getFileStart(file))
    {
      strcpy(path,file);
      return;
    }
  }
  else
  {
    strcpy(s,currentFile);
    char* u=strrchr(s,'/');
    if (u>s)
    {
      *(u+1)=0;
    }
    else
    {
      sprintf(errText,"currentFile has no path?!?"); errExit();
    }
    strcat(s,file);
    strcpy(t,s);
    char* ssrc=s;
    char* sdest=t;
    while ((sf=strstr(ssrc,"/.."))>0)
    {
      *(sdest+ (sf-ssrc)) =0;
      sdest = strrchr(t,'/');
      if (sdest<=t)
      {
        break;
      }
      ssrc = sf+3;
      strcpy(sdest,ssrc);
    }
    if ((sdest>=t)&&(getFileStart(t)))
    {
      strcpy(path,t);
      return;
    }

    for (int i=0;i<numberOfIncDirs;i++)
    {
      if (i==MAXINCDIR)
      {
        sprintf(errText,"too many includes, increase MAXINCDIR in Depend.cpp");
      }
      sprintf(s,"%s/%s",incDirList[i],file);
      strcpy(t,s);
      char* ssrc=s;
      char* sdest=t;
      while ((sf=strstr(ssrc,"/.."))>0)
      {
        *(sdest+ (sf-ssrc)) =0;
        sdest = strrchr(t,'/');
        if (sdest<=t)
        {
          break;
        }
        ssrc = sf+3;
        strcpy(sdest,ssrc);
      }
      if (sdest<t)
      {
        continue;
      }
      if (getFileStart(t))
      {
        strcpy(path,t);
        return;
      }
    }
  }
  sprintf(errText,"include file not found: %s",file); errExit();
}

void define(const char* s)
{
  for (int i=0;i<numberOfDefs;i++)
  {
    if (strcmp(defList[i],s)==0)
    {
      return;
    }
  }
  if (numberOfDefs>=MAXDEFS+1)
  {
    sprintf(errText,"too many defines, increase MAXDEFS in Depend.cpp"); errExit();
  }
  strcpy(defList[numberOfDefs++],s);
}

void undef(const char* s)
{
  for (int i=0;i<numberOfDefs;i++)
  {
    if (strcmp(defList[i],s)==0)
    {
      numberOfDefs--;
      for (int j=i;j<numberOfDefs;j++)
      {
        strcpy(defList[j],defList[j+1]);
      }
      return;
    }
  }
}

bool ifdef(const char* s)
{
  for (int i=0;i<numberOfDefs;i++)
  {
    if (strcmp(defList[i],s)==0)
    {
      return true;
    }
  }
  return false;
}

bool ifndef(const char* s)
{
  return !ifdef(s);
}

void skipSpaces(char** p)
{
  while (((**p)==' ')||((**p)=='\t')||((**p)=='\r')||((**p)=='\n'))
  {
    if ((**p)=='\n')
    {
      (*currentLine)++;
    }
    (*p)++;
  }
}

void skipCurrentLine(char** p)
{
  while (((**p)!=0)&&((**p)!='\r')&&((**p)!='\n'))
  {
    (*p)++;
  }
  while (((**p)=='\r')||((**p)=='\n'))
  {
    if ((**p)=='\n')
    {
      (*currentLine)++;
    }
    (*p)++;
  }
}

void parseIf(char** p)
{
  if (strncmp(*p,"#if ",4)==0)
  {
    (*p) += 4;
    bool savedInsideIf=weAreInsideIf;
    char* oldP;
    weAreInsideIf=true;
    while(*p)
    {
      skipSpaces(p);
      oldP = *p;
      parseIf(p);
      parseIfdef(p);
      parseIfndef(p);
      parseDefine(p);
      parseUndef(p);
      parseInclude(p);
      skipComment(p);
      //ignore #elif
      if (strncmp(*p,"#endif",6)==0)
      {
        (*p) += 6;
        weAreInsideIf=savedInsideIf;
        return;
      }
      if ((*p)==oldP)
      {
        skipCurrentLine(p);
      }
    }
    sprintf(errText,"#if block without #endif"); errExit();
  }
}

void parseIfdef(char** p)
{
  if (strncmp(*p,"#ifdef ",7)==0)
  {
    (*p) += 7;
    bool savedInsideIf=weAreInsideIf;
    char* oldP;
    char t[MAXDEFLEN];
    if (sscanf(*p,"%s",t)==1)
    {
      (*p) += strlen(t);
      bool shallBeExecuted=ifdef(t);
      while(*p)
      {
        skipSpaces(p);
        oldP = *p;
        if (shallBeExecuted)
        {
          parseIf(p);
          parseIfdef(p);
          parseIfndef(p);
          parseDefine(p);
          parseUndef(p);
          parseInclude(p);
          skipComment(p);
        }
        if (strncmp(*p,"#else",5)==0)
        {
          (*p) += 5;
          shallBeExecuted = !shallBeExecuted;
        }
        else if (strncmp(*p,"#elif ",6)==0)
        {
          (*p) += 6;
          weAreInsideIf=true;
        }
        else if (strncmp(*p,"#endif",6)==0)
        {
          (*p) += 6;
          weAreInsideIf=savedInsideIf;
          return;
        }
        if ((*p)==oldP)
        {
          skipCurrentLine(p);
        }
      }
      sprintf(errText,"#ifdef block without #endif"); errExit();
    }
    else
    {
      sprintf(errText,"#ifdef without param"); errExit();
    }
  }
}


void parseIfndef(char** p)
{
  if (strncmp(*p,"#ifndef ",8)==0)
  {
    (*p) += 8;
    bool savedInsideIf=weAreInsideIf;
    char* oldP;
    char t[MAXDEFLEN];
    if (sscanf(*p,"%s",t)==1)
    {
      (*p) += strlen(t);
      bool shallBeExecuted=ifndef(t);
      while(*p)
      {
        skipSpaces(p);
        oldP = *p;
        if (shallBeExecuted)
        {
          parseIf(p);
          parseIfdef(p);
          parseIfndef(p);
          parseDefine(p);
          parseUndef(p);
          parseInclude(p);
          skipComment(p);
        }
        if (strncmp(*p,"#else",5)==0)
        {
          (*p) += 5;
          shallBeExecuted = !shallBeExecuted;
        }
        else if (strncmp(*p,"#elif ",6)==0)
        {
          (*p) += 6;
          weAreInsideIf=true;
        }
        else if (strncmp(*p,"#endif",6)==0)
        {
          (*p) += 6;
          weAreInsideIf=savedInsideIf;
          return;
        }
        if ((*p)==oldP)
        {
          skipCurrentLine(p);
        }
      }
      sprintf(errText,"#ifndef block without #endif"); errExit();
    }
    else
    {
      sprintf(errText,"#ifndef without param"); errExit();
    }
  }
}

void parseInclude(char** p)
{
  if (strncmp(*p,"#include \"",10)==0)
  {
    if (weAreInsideIf)
    {
      sprintf(errText,"#include inside #if, use #if[n]def instead of #if"); errExit();
    }
    (*p) += 10;
    char* t=strchr(*p,'"');
    if (t>(*p)+2)
    {
      char s[MAXPATH];
      strncpy(s,*p,t-(*p));
      s[t-(*p)]=0;
      char* u=strchr(s,'\\');
      if (u>t)
      {
        sprintf(errText,"include path contains '\\': %s",s); errExit();
      }
      char path[MAXPATH];
      getPath(path,s);
      addDep(path);
      //do not add cpps from these directories, because they are in libraries:
      if ((strstr(path,"/SimRob95/")<=path)&&
          (strstr(path,"/SimRobXP/")<=path))
      {
        parseFile(path);
        sprintf((char*)&path[strlen(path)-2],".cpp");
        addCpp(path);
      }
      (*p) = t+1;
    }
    else
    {
      sprintf(errText,"unterminated include path"); errExit();
    }
  }
}

void parseDefine(char** p)
{
  if (strncmp(*p,"#define ",8)==0)
  {
    (*p) += 8;
    char t[MAXDEFLEN];
    if (sscanf(*p,"%s",t)==1)
    {
      define(t);
    }
    else
    {
      sprintf(errText,"define without param"); errExit();
    }
    (*p) += strlen(t);
  }
}

void parseUndef(char** p)
{
  if (strncmp(*p,"#undef ",7)==0)
  {
    (*p) += 7;
    char t[MAXDEFLEN];
    if (sscanf(*p,"%s",t)==1)
    {
      undef(t);
    }
    else
    {
      sprintf(errText,"undef without param"); errExit();
    }
    (*p) += strlen(t);
  }
}

void skipComment(char** p)
{
  if (strncmp(*p,"/*",2)==0)
  {
    char* t=strstr((*p)+2,"*/");
    if(t>(*p))
    {
      char* u=strchr((*p)+2,'\n');
      while ((u>(*p))&&(u<t))
      {
        skipCurrentLine(p);
        u=strchr((*p)+2,'\n');
      }
      *p = t+2;
    }
    else
    {
      sprintf(errText,"unfinished comment"); errExit();
    }
  }
}

void parseFile(char* s)
{
  char* o=getFileStart(s);
  if (o>0)
  {
    char* savedFile=currentFile;
    int* savedLine=currentLine;
    currentFile=s;
    int line=1;
    currentLine=&line;
    char** p=&o;
    char* oldP;
    while(**p)
    {
      skipSpaces(p);
      oldP= *p;
      parseIf(p);
      parseIfdef(p);
      parseIfndef(p);
      parseDefine(p);
      parseUndef(p);
      parseInclude(p);
      skipComment(p);
      if ((*p)==oldP)
      {
        skipCurrentLine(p);
      }
    }
    currentFile=savedFile;
    currentLine=savedLine;
  }
  else
  {
    char* empty="NoSuchFile";
    int line=0;
    currentFile=empty;
    currentLine=&line;
    sprintf(errText,"couldn't open %s",s); errExit();
  }
}

void checkOdep(char* s)
{
  int i;
  for (i=0;i<numberOfBindeps[currentBin];i++)
  {
    if (strcmp(bindepList[currentBin][i],s)==0)
    {
      return;
    }
  }

  int foundCpp=-1;
  for (i=0;i<numberOfCpps;i++)
  {
    if (strcmp(cppList[i],s)==0)
    {
      foundCpp=i;
      break;
    }
  }
  if (foundCpp>=0)
  {
    bindepList[currentBin][numberOfBindeps[currentBin]++]=cppList[foundCpp];
    //recursive call for all potential cpps from odeps
    for (int j=1;j<numberOfOdeps[foundCpp];j++)
    {
      char cpp[MAXPATH];
      strcpy(cpp,odepList[foundCpp][j]);
      if (strcmp(cpp+strlen(cpp)-2,".h")==0)
      {
        strcpy(cpp+strlen(cpp)-2,".cpp");
      }
      else if (strcmp(cpp+strlen(cpp)-2,".H")==0)
      {
        strcpy(cpp+strlen(cpp)-2,".CPP");
      }
      checkOdep(cpp);
    }
  }
}

void parseBins()
{
  currentCpp=0;
  for (currentBin=0;currentBin<numberOfBins;currentBin++)
  {
    numberOfBindeps[currentBin]=0;

    //and has to be added to list of all (linked) cpp files
    addCpp(binList[currentBin]);
    //make odeps for alle binaries (addionally needed for this bin)
    while(currentCpp<numberOfCpps)
    {
      numberOfDefs=numberOfSysDefs;
      memcpy(defList,sysDefList,sizeof(defList));
      numberOfOdeps[currentCpp]=0;
      //main cpp is first file in its object dependency list
      addDep(cppList[currentCpp]);
      parseFile(cppList[currentCpp]);
      currentCpp++;
    }
    //make bindeps for current bin, the ones for first bin are already complete (done by addCpp)
    if (currentBin>0)
    {
      numberOfBindeps[currentBin]=0;
      checkOdep(binList[currentBin]);
    }
  }
}

void getOFromCpp(char* o, const char* cpp)
{
  char* t;
  t=strstr(cpp,"/Src/");
  if (t>cpp)
  {
    sprintf(o,"%s/%s",buildDir,t+5);
    sprintf(o+strlen(o)-4,".o");
  }
  else
  {
    sprintf(errText,"mysterious odep error in getOFromCpp(%s)",cpp); errExit();
  }
}

void generateDspMiddle()
{
  //build tree with cpps and hs
  dspNode root("../Src","Src");
  for (currentCpp=0;currentCpp<numberOfCpps;currentCpp++)
  {
    for (int i=0;i<numberOfOdeps[currentCpp];i++)
    {
      char* found=strstr(odepList[currentCpp][i],"/Src/");
      if (found)
      {
        root.add(found+5);
      }
      else
      {
        //2do: mysteris
      }
    }
  }
  char filename[MAXPATH];
  if (generateDsp)
  {
    sprintf(filename,"%s/dsp.middle",buildDir);
    FILE* f=fopen(filename,"wb");
    if (f>0)
    {
      root.dsprintf(f);
      fclose(f);
    }
    else
    {
      printf("error: couldn't create %s\n",filename); exit(1);
    }
  }
  if (generateVcproj)
  {
    sprintf(filename,"%s/vcproj.middle",buildDir);
    FILE* f=fopen(filename,"wb");
    if (f>0)
    {
      root.vcprintf(f,2);
      fclose(f);
    }
    else
    {
      printf("error: couldn't create %s\n",filename); exit(1);
    }
  }
}

void generateOdeps(FILE* f)
{
  for (currentCpp=0;currentCpp<numberOfCpps;currentCpp++)
  {
    char o[MAXPATH];
    getOFromCpp(o,cppList[currentCpp]);
    fprintf(f,"%s:",o);
    for (int i=0;i<numberOfOdeps[currentCpp];i++)
    {
      fprintf(f," %s",odepList[currentCpp][i]);
    }
    fprintf(f,"\n\n");
  }
}

void generateBindeps(FILE* f)
{
  char bin[MAXPATH];
  char _bin[MAXPATH];
  char __bin[MAXPATH];
  char ___bin[MAXPATH];
  for (currentBin=0;currentBin<numberOfBins;currentBin++)
  {
    sprintf(bin,"%s/bin/%s.bin",buildDir,binNameList[currentBin]);
    sprintf(_bin,"%s/bin/%s._bin",buildDir,binNameList[currentBin]);
    sprintf(__bin,"%s/bin/%s.__bin",buildDir,binNameList[currentBin]);
    sprintf(___bin,"%s/bin/%s.___bin",buildDir,binNameList[currentBin]);
    if (ifdef("__GNUC__"))
    {
      fprintf(f,"%s:",bin);
    }
    else
    {
      fprintf(f,"%s:",___bin);
    }
    for (int i=0; i<numberOfBindeps[currentBin];i++)
    {
      char o[MAXPATH];
      getOFromCpp(o,bindepList[currentBin][i]);
      fprintf(f," %s",o);
    }
    fprintf(f,"\n");
    if (ifdef("__GNUC__"))
    {
      fprintf(f,"\t@echo \"! link %s\"\n",bin);
      fprintf(f,"\t@grep \"^object %s\" $(SDIR)/$(PROCSET).ocf >%s.unstripped.ocf\n",binNameList[currentBin],bin);
      fprintf(f,"\t@(cd %s/bin && $(MKBIN) $(MKBINFLAGS) -o %s.bin.unstripped $^ $(LIB_INC:%%=-L%%) $(LIBS:%%=-l%%)) 2>&1 |sed 's/\\(.*\\):\\([0-9]*\\): /\\1(\\2): error : /' |sed 's/collect2: ld returned 1 exit status/Fehler beim Ausfhren von ld/' |sed 's/mkbin: running the following command failed.*/Fehler beim Ausfhren von mkbin/' |sed 's/.* -o \\([^ ]*\\) -T .*/\\1: error : Linkfehler (nicht aufgelste externe Verweise?!)/'\n",buildDir,binNameList[currentBin]);
   	  fprintf(f,"\t@cp %s.unstripped %s\n",bin,bin);
      fprintf(f,"\t@$(STRIP) %s\n",bin);
      fprintf(f,"\t@echo \"! build %s complete!\"\n\n",bin);
    }
    else
    {
      fprintf(f,"\t@echo \"! link %s\"\n",___bin);
      fprintf(f,"\t@$(LD) $(LIB_INC:%%=-L%%) -elf -e Prologue -nocpp -r -o %s $^ $(LIBS:%%=-l%%)\n\n",___bin);
      fprintf(f,"%s: %s\n\n",__bin,___bin);
      fprintf(f,"%s: %s\n\n",_bin,__bin);
      fprintf(f,"%s: %s\n\n",bin,_bin);
    }
  }

  fprintf(f,"objects:");
  for (currentBin=0;currentBin<numberOfBins;currentBin++)
  {
    sprintf(bin,"%s/bin/%s.bin",buildDir,binNameList[currentBin]);
    fprintf(f," %s",bin);
  }
  fprintf(f,"\n\n");
}

void addDep(const char* s)
{
  for (int i=0;i<numberOfOdeps[currentCpp];i++)
  {
    if (strcmp(odepList[currentCpp][i],s)==0)
    {
      return;
    }
  }
  odepList[currentCpp][numberOfOdeps[currentCpp]++]=strdup(s);
}

void addCpp(const char* s)
{
  bool isInCppList=false;
  bool isValid=true;
  int cppIndex=-1;
  for (int i=0;i<numberOfCpps;i++)
  {
    if (strcmp(cppList[i],s)==0)
    {
      isInCppList=true;
      cppIndex=i;
      break;
    }
  }
  if (!isInCppList)
  {
    isValid = (getFileStart(s)>0);
  }
  if (isValid)
  {
    if (!isInCppList)
    {
      cppIndex=numberOfCpps;
      strcpy(cppList[numberOfCpps++],s);
    }
    for (int i=0;i<numberOfBindeps[currentBin];i++)
    {
      if (strcmp(bindepList[currentBin][i],s)==0)
      {
        return;
      }
    }
    //bindeps after that only contains files that are needed directly or additionally to the ones needed in earlier bins!
    bindepList[currentBin][numberOfBindeps[currentBin]++]=cppList[cppIndex];
  }
}

void addBin(const char* cpp, const char* binname)
{
  if (numberOfBins<MAXBIN)
  {
    strcpy(binList[numberOfBins],cpp);
    strcpy(binNameList[numberOfBins++],binname);
  }
  else
  {
    sprintf(errText,"increse MAXBIN in Depend.cpp!"); errExit();
  }
}

void usage()
{
  printf("\nusage:\n");
  printf(" Depend <options> <process1>=<process1.cpp> <process2>=<process2.cpp> ...\n\n");
  printf("options (similar to gcc ones):\n");
  printf(" -I<includedir>\n");
  printf(" -D<define>\n");
  printf(" -B<builddir>\t\t(exactly 1 required)\n");
  printf(" -P<processset>\t\t(exactly 1 required)\n");
  printf(" -G\t\t(generate dsp.middle in builddir)\n");
  printf(" -V<ProjectName>\t\t(generate vcproj.middle in builddir, use empty ProjectName for external compilation)\n");
  printf(" -*\t\t\t(ignored)\n\n");
  printf("example:\n");
  printf(" Depend -DWLAN -I%s/Src -DAPERIOS1_3_2 -B%s/Build/GT2004/CMD/Debug -PCMD Cognit=Cognition.cpp Debug=Debug.cpp\n\n",File::getGTDir(),File::getGTDir());
  _exit(1);
}

int main(int argc, char* argv[])
//int main()
{
  //int argc=14;
  //char* argv[]={"d:/sony/dueffert/GT2004/Bin/Depend.exe","-G","-V_RobotControl","-Id:/sony/dueffert/GT2004/Src","-Id:/sony/dueffert/GT2004/Src/RobotControl","-DLARGE_FIELD","-D_WIN32","-DWLAN","-PCMD","-Bd:/sony/dueffert/GT2004/Build/RobotControl/CMD","RobotControl=d:/sony/dueffert/GT2004/Src/RobotControl/RobotControl.cpp","Cognit=Cognition.cpp","Motion=Motion.cpp","Debug=Debug.cpp"};
  //int argc=21;
  //char* argv[]={"d:/sony/dueffert/GT2004/Bin/Depend.exe","-G","-V_Simulator","-Id:/sony/dueffert/GT2004/Src/SimRobXP","-Id:/sony/dueffert/GT2004/Src","-Id:/sony/dueffert/GT2004/Src/RobotControl","-DLARGE_FIELD","-D_DEBUG","-DSIMROBOT","-DWIN32","-D_WIN32","-D_WINDOWS","-D__WIN32__","-D_AFXDLL","-D_MBCS","-PCMD","-Bd:/sony/dueffert/GT2004/Build/Simulator/CMD","RobotConsole=../../Platform/Win32/ForSimRobXP/RobotConsole.cpp","Cognit=Cognition.cpp","Motion=Motion.cpp","Debug=Debug.cpp"};
  
  
  //load all potential source files into memory
  numberOfFiles=0;
  currentBuf=buffer;
  char sd[MAXPATH];
  sprintf(sd,"%s/Src",File::getGTDir());
  addSourceDir(sd);
  sortFileList(0,numberOfFiles-1);

  //initialize current file and line number for error output
  char path[MAXPATH];
  currentFile=path;
  int line=0;
  currentLine=&line;

  generateDsp=false;
  generateVcproj=false;
  weAreInsideIf=false;
  numberOfDefs=0;
  numberOfSysDefs=0;
  numberOfIncDirs=0;
  buildDir[0]=0;
  processSet[0]=0;
  projectName[0]=0;

  numberOfBins=0;
  numberOfCpps=0;
  currentCpp=0;

  bool cppGiven=false;
  for (int i=1;i<argc;i++)
  {
    if (strncmp(argv[i],"-D",2)==0)
    {
      define(argv[i]+2);
    }
    else if (strncmp(argv[i],"-I",2)==0)
    {
      strcpy(incDirList[numberOfIncDirs++],argv[i]+2);
    }
    else if (strncmp(argv[i],"-B",2)==0)
    {
      if (buildDir[0]==0)
      {
        strcpy(buildDir,argv[i]+2);
      }
      else
      {
        usage();
      }
    }
    else if (strncmp(argv[i],"-P",2)==0)
    {
      if (processSet[0]==0)
      {
        strcpy(processSet,argv[i]+2);
      }
      else
      {
        usage();
      }
    }
    else if (strncmp(argv[i],"-G",2)==0)
    {
      generateDsp=true;
    }
    else if (strncmp(argv[i],"-V",2)==0)
    {
      generateVcproj=true;
      strcpy(projectName,&argv[i][2]);
    }
    else if (argv[i][0]=='-')
    {
      //ignore unknown parameter
    }
    else if ((strlen(argv[i])>4)&&(strcmp(argv[i]+strlen(argv[i])-4,".cpp")==0)&&(buildDir[0]!=0)||(processSet[0]!=0))
    {
      char dir[MAXPATH];
      strcpy(dir,argv[i]);
      char* t=strchr(dir,'=');
      if (t>dir)
      {
        //initialize path with current src dir
        char* u=strstr(buildDir,"/Build/");
        if (u<=buildDir)
        {
          printf("Error: buildDir invalid\n"); return(1);
        }
        strcpy(path,buildDir);
        sprintf(path+(u-buildDir),"/Src/Processes/%s/CorrectDirNoFile",processSet);

        *t=0;
        cppGiven=true;
        getPath(path,t+1);
        addBin(path,dir);
      }
      else
      {
        usage();
      }
    }
    else
    {
      usage();
    }
  }
  if ((buildDir[0]==0)||(processSet[0]==0)||(!cppGiven))
  {
    usage();
  }

  //make copy of defines to be used for each new cpp at start
  numberOfSysDefs=numberOfDefs;
  memcpy(sysDefList,defList,sizeof(defList));

  //parse all cpp files needed to link binaries
  parseBins();

  //output dependencies
  char filename[MAXPATH];
  sprintf(filename,"%s/depends.incl",buildDir);
  FILE* f=fopen(filename,"wb");
  if (f>0)
  {
    generateOdeps(f);
    generateBindeps(f);
    fclose(f);
    if (generateDsp||generateVcproj)
    {
      generateDspMiddle();
    }
  }
  else
  {
    printf("error: couldn't create %s\n",filename); return(1);
  }

  return 0;
}

/*
* Change log :
*
* $Log: Depend.cpp,v $
* Revision 1.11  2004/04/12 14:21:27  dueffert
* cmdline parameter fakes for debugging renewed
*
* Revision 1.10  2004/03/19 19:01:38  roefer
* Exclude files in GUI from _Simulator
*
* Revision 1.9  2004/02/13 17:29:45  dueffert
* /obj removed (see newsgroup)
*
* Revision 1.8  2004/01/30 21:59:28  dueffert
* new idea dded
*
* Revision 1.7  2004/01/30 21:12:20  dueffert
* all configuration named consequently
*
* Revision 1.6  2004/01/29 03:04:17  dueffert
* vcproj generation improved
*
* Revision 1.5  2004/01/28 08:38:56  dueffert
* vcprj renamed to vcproj
*
* Revision 1.4  2003/12/02 18:06:26  dueffert
* vcprj support added
*
* Revision 1.3  2003/11/28 14:45:45  dueffert
* Depend generates dsp file lists now too
*
* Revision 1.2  2003/11/17 17:15:14  dueffert
* SimRobXP bug fixed
*
* Revision 1.1  2003/10/06 13:32:26  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/08/29 12:00:16  roefer
* Unnecessary includes removed
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.7  2003/05/21 09:04:05  dueffert
* possible bug fixed
*
* Revision 1.6  2003/05/20 15:47:01  dueffert
* path independency restored
*
* Revision 1.5  2003/05/11 23:38:27  dueffert
* Depend now works with RobotControl too
*
* Revision 1.4  2003/05/06 08:03:04  dueffert
* no message
*
* Revision 1.3  2003/05/05 15:05:54  dueffert
* changelog added
*
*/
