/**
* @file ATHAiboControlDlg.h
*
* Definition of the ATHAiboControl dialogs
*
* @author Martin Ltzsch
*/

#ifndef __ATHAiboControlDlg_h_
#define __ATHAiboControlDlg_h_

/**
* @class CATHAiboControlDlg1
* 
* The first configuration dialog which appaers before the main dialog
*
* @author Martin Ltzsch
*/
class CATHAiboControlDlg1 : public CDialog
{
public:
	CATHAiboControlDlg1(CWnd* pParent = NULL);

  /** Updates the buttons and bitmaps */
  void update();

	//{{AFX_DATA(CATHAiboControlDlg1)
	enum { IDD = IDD_ATHAIBOCONTROL_DIALOG };
	CComboBox	m_configurationCombo;
	CStatic	m_JoystickBitmap2;
	CStatic	m_ConnectBitmap2;
	CStatic	m_ConnectBitmap;
	CStatic	m_JoystickBitmap;
	CIPAddressCtrl	m_IpControl;
	CButton	m_ConnectButton;
	//}}AFX_DATA

	//{{AFX_VIRTUAL(CATHAiboControlDlg1)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);
	//}}AFX_VIRTUAL

protected:
	HICON m_hIcon;

	//{{AFX_MSG(CATHAiboControlDlg1)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg void OnConnectButton();
	afx_msg void OnFieldchangedIpaddress(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnDestroy();
	afx_msg void OnSelchangeConfigurationCombo();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/**
* @class CATHAiboControlDlg2
* 
* The main dialog
*
* @author Martin Ltzsch
*/
class CATHAiboControlDlg2 : public CDialog
{
public:
	CATHAiboControlDlg2(CWnd* pParent = NULL);

  /** Updates the buttons and bitmaps */
  void update();

	//{{AFX_DATA(CATHAiboControlDlg2)
	enum { IDD = IDD_ATHAIBOCONTROL_DIALOG2 };
	//}}AFX_DATA

	//{{AFX_VIRTUAL(CATHAiboControlDlg2)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);
	//}}AFX_VIRTUAL

protected:
	HICON m_hIcon;

	//{{AFX_MSG(CATHAiboControlDlg2)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnDestroy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


#endif // __ATHAiboControlDlg_h_

/** 
* Change Log:
*
* $Log: ATHAiboControlDlg.h,v $
* Revision 1.2  2004/01/26 13:35:02  loetzsch
* improved
*
* Revision 1.1  2004/01/24 14:55:28  loetzsch
* created ATH AiboControl
*
*/
