/*
 * Decompiled with CFR 0.152.
 */
public class Matrix {
    private double[][] array;
    private int type;
    public static final int MATRIX = 0;
    public static final int IDENTITY = 1;
    public static final int VECTOR = 2;

    public Matrix(Matrix matrix) {
        this.type = matrix.type;
        if (this.type == 0) {
            this.array = new double[2][2];
            this.array[0][0] = matrix.array[0][0];
            this.array[1][0] = matrix.array[1][0];
            this.array[0][1] = matrix.array[0][1];
            this.array[1][1] = matrix.array[1][1];
        } else {
            this.array = new double[2][1];
            this.array[0][0] = matrix.array[0][0];
            this.array[1][0] = matrix.array[1][0];
        }
    }

    public Matrix(int n) {
        switch (n) {
            case 0: {
                this.array = new double[2][2];
                this.type = 0;
                break;
            }
            case 1: {
                this.array = new double[2][2];
                this.array[0][0] = 1.0;
                this.array[0][1] = 0.0;
                this.array[1][0] = 0.0;
                this.array[1][1] = 1.0;
                this.type = 0;
                break;
            }
            default: {
                this.array = new double[2][1];
                this.type = n;
            }
        }
    }

    public void setElement(int n, int n2, double d) {
        this.array[n][n2] = d;
    }

    public double getElement(int n, int n2) {
        return this.array[n][n2];
    }

    public Matrix print() {
        if (this.type == 0) {
            System.out.println("[" + this.array[0][0] + "]" + '\t' + "[" + this.array[0][1] + "]");
            System.out.println("[" + this.array[1][0] + "]" + '\t' + "[" + this.array[1][1] + "]");
            System.out.println("");
        } else {
            System.out.println("[" + this.array[0][0] + "]");
            System.out.println("[" + this.array[1][0] + "]");
            System.out.println("");
        }
        return this;
    }

    public double det() throws MatrixException {
        if (this.type == 0) {
            return this.array[0][0] * this.array[1][1] - this.array[1][0] * this.array[0][1];
        }
        throw new MatrixException("Determinant: undefined for vectors");
    }

    public Matrix mul(Matrix matrix) throws MatrixException {
        if (this.type == 0) {
            if (matrix.type == 0) {
                Matrix matrix2 = new Matrix(0);
                matrix2.array[0][0] = this.array[0][0] * matrix.array[0][0] + this.array[0][1] * matrix.array[1][0];
                matrix2.array[0][1] = this.array[0][0] * matrix.array[0][1] + this.array[0][1] * matrix.array[1][1];
                matrix2.array[1][0] = this.array[1][0] * matrix.array[0][0] + this.array[1][1] * matrix.array[1][0];
                matrix2.array[1][1] = this.array[1][0] * matrix.array[0][1] + this.array[1][1] * matrix.array[1][1];
                return matrix2;
            }
            Matrix matrix3 = new Matrix(2);
            matrix3.array[0][0] = this.array[0][0] * matrix.array[0][0] + this.array[0][1] * matrix.array[1][0];
            matrix3.array[1][0] = this.array[1][0] * matrix.array[0][0] + this.array[1][1] * matrix.array[1][0];
            return matrix3;
        }
        if (matrix.type == 0) {
            Matrix matrix4 = new Matrix(2);
            matrix4.array[0][0] = this.array[0][0] * matrix.array[0][0] + this.array[1][0] * matrix.array[1][0];
            matrix4.array[1][0] = this.array[0][0] * matrix.array[0][1] + this.array[1][0] * matrix.array[1][1];
            return matrix4;
        }
        throw new MatrixException("Multiplication: Vector-Vector Unsupported type");
    }

    public Matrix trans() {
        if (this.type == 2) {
            return this;
        }
        Matrix matrix = new Matrix(0);
        matrix.array[0][0] = this.array[0][0];
        matrix.array[0][1] = this.array[1][0];
        matrix.array[1][0] = this.array[0][1];
        matrix.array[1][1] = this.array[1][1];
        return matrix;
    }

    public Matrix scalarMul(double d) {
        if (this.type == 0) {
            Matrix matrix = new Matrix(0);
            matrix.array[0][0] = d * this.array[0][0];
            matrix.array[0][1] = d * this.array[0][1];
            matrix.array[1][0] = d * this.array[1][0];
            matrix.array[1][1] = d * this.array[1][1];
            return matrix;
        }
        Matrix matrix = new Matrix(2);
        matrix.array[0][0] = d * this.array[0][0];
        matrix.array[1][0] = d * this.array[1][0];
        return matrix;
    }

    public Matrix add(Matrix matrix) throws MatrixException {
        if (this.type == 0 && matrix.type == 0) {
            Matrix matrix2 = new Matrix(0);
            matrix2.array[0][0] = this.array[0][0] + matrix.array[0][0];
            matrix2.array[0][1] = this.array[0][1] + matrix.array[0][1];
            matrix2.array[1][0] = this.array[1][0] + matrix.array[1][0];
            matrix2.array[1][1] = this.array[1][1] + matrix.array[1][1];
            return matrix2;
        }
        if (this.type == 2 && matrix.type == 2) {
            Matrix matrix3 = new Matrix(2);
            matrix3.array[0][0] = this.array[0][0] + matrix.array[0][0];
            matrix3.array[1][0] = this.array[1][0] + matrix.array[1][0];
            return matrix3;
        }
        throw new MatrixException("Add: argument type mismatch - op undefined");
    }

    public Matrix sub(Matrix matrix) throws MatrixException {
        if (this.type == 0 && matrix.type == 0) {
            Matrix matrix2 = new Matrix(0);
            matrix2.array[0][0] = this.array[0][0] - matrix.array[0][0];
            matrix2.array[0][1] = this.array[0][1] - matrix.array[0][1];
            matrix2.array[1][0] = this.array[1][0] - matrix.array[1][0];
            matrix2.array[1][1] = this.array[1][1] - matrix.array[1][1];
            return matrix2;
        }
        if (this.type == 2 && matrix.type == 2) {
            Matrix matrix3 = new Matrix(2);
            matrix3.array[0][0] = this.array[0][0] - matrix.array[0][0];
            matrix3.array[1][0] = this.array[1][0] - matrix.array[1][0];
            return matrix3;
        }
        throw new MatrixException("Sub: argument type mismatch - op undefined");
    }

    public Matrix inv() throws MatrixException {
        double d = this.det();
        if (d == 0.0) {
            throw new MatrixException("Inv: Singular Matrix - op impossible");
        }
        Matrix matrix = new Matrix(0);
        matrix.array[0][0] = this.array[1][1] / d;
        matrix.array[0][1] = -(this.array[0][1] / d);
        matrix.array[1][0] = -(this.array[1][0] / d);
        matrix.array[1][1] = this.array[0][0] / d;
        return matrix;
    }

    public Matrix EigenValues() throws MatrixException {
        double d = -this.array[0][0] - this.array[1][1];
        double d2 = -this.array[0][1] * this.array[1][0] + this.array[0][0] * this.array[1][1];
        double d3 = d * d - 4.0 * d2;
        if (d3 > 0.0) {
            Matrix matrix = new Matrix(0);
            matrix.array[0][0] = (-d + Math.sqrt(d3)) / 2.0;
            matrix.array[1][1] = (-d - Math.sqrt(d3)) / 2.0;
            return matrix;
        }
        if (d3 > -1.0E-7) {
            Matrix matrix = new Matrix(0);
            matrix.array[0][0] = -d / 2.0;
            matrix.array[1][1] = -d / 2.0;
            return matrix;
        }
        throw new MatrixException("EigenValues: Complex Values - unsupported. Delta: " + d3);
    }

    public Matrix EigenVectors() throws MatrixException {
        double d;
        Matrix matrix = this.EigenValues();
        Matrix matrix2 = this.sub(new Matrix(1).scalarMul(matrix.array[0][0]));
        Matrix matrix3 = this.sub(new Matrix(1).scalarMul(matrix.array[1][1]));
        Matrix matrix4 = new Matrix(0);
        if (Math.abs(matrix2.array[1][1]) < 1.0E-7) {
            double d2 = 0.0;
            double d3 = 1.0;
            matrix4.array[0][0] = d2;
            matrix4.array[1][0] = d3;
        } else {
            double d4 = 1.0;
            double d5 = -this.array[1][0] / matrix2.array[1][1];
            d = Math.sqrt(d4 * d4 + d5 * d5);
            matrix4.array[0][0] = d4 / d;
            matrix4.array[1][0] = d5 / d;
        }
        if (Math.abs(matrix3.array[0][0]) < 1.0E-7) {
            double d6 = 1.0;
            double d7 = 0.0;
            matrix4.array[0][1] = d6;
            matrix4.array[1][1] = d7;
        } else {
            double d8 = 1.0;
            double d9 = -this.array[0][1] / matrix3.array[0][0];
            d = Math.sqrt(d8 * d8 + d9 * d9);
            matrix4.array[0][1] = d9 / d;
            matrix4.array[1][1] = d8 / d;
        }
        return matrix4;
    }

    public static void main(String[] stringArray) throws MatrixException {
        Matrix matrix = new Matrix(0);
        matrix.setElement(0, 0, 1.0);
        matrix.setElement(0, 1, 2.0);
        matrix.setElement(1, 0, 3.0);
        matrix.setElement(1, 1, 2.0);
        Matrix matrix2 = new Matrix(0);
        matrix2.setElement(0, 0, 1.0);
        matrix2.setElement(0, 1, 1.0);
        matrix2.setElement(1, 0, 2.0);
        matrix2.setElement(1, 1, 2.0);
        Matrix matrix3 = matrix.mul(matrix2);
        matrix3.print();
        matrix2.print();
        Matrix matrix4 = new Matrix(2);
        matrix4.setElement(0, 0, 1.0);
        matrix4.setElement(1, 0, 1.0);
        Matrix matrix5 = new Matrix(2);
        matrix5.setElement(0, 0, 1.0);
        matrix5.setElement(1, 0, -2.0);
        matrix.mul(matrix4).print();
        matrix4.mul(matrix).print();
        matrix.inv().print();
        matrix.mul(matrix.inv()).print();
        System.out.println(matrix.det());
        System.out.println(matrix2.det());
        Matrix matrix6 = new Matrix(1);
        matrix6.print();
        matrix6.scalarMul(3.0).print();
        matrix6.scalarMul(3.0).add(matrix).print();
        matrix6.scalarMul(3.0).sub(matrix).print();
        matrix6.scalarMul(3.0).sub(matrix).trans().print();
        matrix4.add(matrix5).print();
        matrix4.sub(matrix5).print();
        matrix4.sub(matrix5).trans().print();
        matrix4.scalarMul(3.0).print();
        Matrix matrix7 = new Matrix(0);
        double d = 2.356194490192345;
        matrix7.setElement(0, 0, Math.cos(d));
        matrix7.setElement(0, 1, -Math.sin(d));
        matrix7.setElement(1, 0, Math.sin(d));
        matrix7.setElement(1, 1, Math.cos(d));
        matrix7.print();
        matrix7.mul(matrix7.trans()).print();
        Matrix matrix8 = new Matrix(0);
        matrix8.setElement(0, 0, 1.0);
        matrix8.setElement(0, 1, 0.0);
        matrix8.setElement(1, 0, 0.0);
        matrix8.setElement(1, 1, -2.0);
        matrix8.print();
        matrix8.EigenValues().print();
        matrix8.EigenVectors().print();
        Matrix matrix9 = matrix8.EigenVectors();
        matrix9.trans().mul(matrix8).mul(matrix9).print();
        Matrix matrix10 = matrix7.mul(matrix8).mul(matrix7.trans()).print();
        matrix10.EigenValues().print();
        matrix10.EigenVectors().print();
        double d2 = Math.asin(-matrix10.EigenVectors().getElement(0, 1));
        double d3 = Math.acos(matrix10.EigenVectors().getElement(0, 0));
        double d4 = Math.atan2(-matrix10.EigenVectors().getElement(0, 1), matrix10.EigenVectors().getElement(0, 0));
        System.out.println(d2 * 180.0 / Math.PI + " " + d3 * 180.0 / Math.PI);
        System.out.println(d4 * 180.0 / Math.PI);
        double d5 = Math.atan2(-matrix8.EigenVectors().getElement(0, 1), matrix8.EigenVectors().getElement(0, 0));
        System.out.println(d5 * 180.0 / Math.PI);
    }

    public class MatrixException
    extends Exception {
        public MatrixException() {
        }

        public MatrixException(String string) {
            super(string);
        }
    }
}

